/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.mongodb.MongoContext;
import com.lubanops.apm.plugin.mongodb.MongoStatsConfig;
import com.lubanops.apm.plugin.mongodb.MongoUtils;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;
import com.lubanops.apm.plugin.mongodb.interceptor.ServerRunCommandInterceptor;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import java.util.List;

public class LegacyProtocolExecutionInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                LegacyProtocolExecutionInterceptor.legacyProtocolOnStart(object, args, className, methodName);
            }
        }
        catch (Exception legacyProtocolExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)legacyProtocolExecutionException);
        }
        return new Object[0];
    }

    public static void legacyProtocolOnStart(Object object, Object[] args, String className, String methodName) throws Exception {
        AttributeAccess attributeAccess;
        Object[] attribute;
        String[] statsArgs = MongoContext.buildStatsArgs();
        String protocolName = args[0].getClass().getSimpleName();
        int indexOfProtocol = protocolName.indexOf("Protocol");
        if (indexOfProtocol > 0) {
            protocolName = protocolName.substring(0, indexOfProtocol);
        }
        if (statsArgs[0].equals("?") && args[0] instanceof AttributeAccess && (attribute = (attributeAccess = (AttributeAccess)args[0]).getLopsFileds()) != null && attribute.length > 0) {
            statsArgs[0] = attribute[0].toString();
        }
        statsArgs[1] = protocolName + ": {" + statsArgs[1] + "}";
        SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"MongoDb");
        Object connection = ((AttributeAccess)object).getLopsFileds()[0];
        ConnectionDescription description = MongoUtils.getConnectionDescription(connection);
        String serverAddr = description.getServerAddress().toString();
        ServerType serverType = description.getServerType();
        MongoDbCollector.onStart(statsArgs[0], statsArgs[1], serverAddr);
        ServerRunCommandInterceptor.onStart(serverAddr, serverType);
        if (spanEvent != null) {
            spanEvent.addTag("namespace", statsArgs[0]);
            spanEvent.addTag("command", statsArgs[1]);
            if (MongoStatsConfig.isParseOriginalCommand && statsArgs[2] != null) {
                spanEvent.addTag("original command", protocolName + ": {" + statsArgs[2] + "}");
            }
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                LegacyProtocolExecutionInterceptor.legacyProtocolOnError(object, args, e, className, methodName);
            }
        }
        catch (Exception legacyProtocolExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)legacyProtocolExecutionException);
        }
    }

    public static void legacyProtocolOnError(Object object, Object[] args, Throwable e, String className, String methodName) {
        MongoDbCollector.onException(e);
        MongoDbCollector.onError(TraceCollector.getTraceId());
        ServerRunCommandInterceptor.onError();
        TraceCollector.onError((Throwable)e);
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                LegacyProtocolExecutionInterceptor.legacyProtocolOnFinally(object, args, result, className, methodName);
            }
        }
        catch (Exception legacyProtocolExecutionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)legacyProtocolExecutionException);
        }
    }

    public static void legacyProtocolOnFinally(Object object, Object[] args, Object result, String className, String methodName) {
        com.mongodb.BulkWriteResult bulkWriteResult;
        int queryCount = 0;
        int updateCount = 0;
        if (result instanceof AttributeAccess) {
            queryCount = ((List)((AttributeAccess)result).getLopsFileds()[0]).size();
        } else if (result instanceof com.mongodb.BulkWriteResult) {
            bulkWriteResult = (com.mongodb.BulkWriteResult)result;
            if (bulkWriteResult.isAcknowledged()) {
                updateCount = bulkWriteResult.getInsertedCount() + bulkWriteResult.getRemovedCount() + bulkWriteResult.getModifiedCount();
            }
        } else if (result instanceof BulkWriteResult && (bulkWriteResult = (BulkWriteResult)result).wasAcknowledged()) {
            updateCount = bulkWriteResult.getInsertedCount() + bulkWriteResult.getDeletedCount() + bulkWriteResult.getModifiedCount();
        }
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        if (spanEvent != null) {
            if (queryCount != 0) {
                spanEvent.addTag("query count", String.valueOf(queryCount));
            }
            if (updateCount != 0) {
                spanEvent.addTag("update count", String.valueOf(updateCount));
            }
        }
        MongoDbCollector.incrementQueryCount(queryCount);
        MongoDbCollector.incrementUpdateCount(updateCount);
        MongoDbCollector.onFinally();
        ServerRunCommandInterceptor.onFinally();
        TraceCollector.onFinally();
    }
}

