/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.collector;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.plugin.mongodb.ConnectionPoolHolder;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerId;
import com.mongodb.internal.connection.ConcurrentPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MongoConnectionPoolAggregator
extends AbstractAggregator {
    public List<MonitorDataRow> harvest() {
        return this.getAllStatus();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public String getName() {
        return "connectionPool";
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        String host = primaryKeyMap.get("host");
        if (host == null) {
            return null;
        }
        for (Map.Entry<ServerId, Object> entry : ConnectionPoolHolder.entrySet()) {
            MonitorDataRow row = this.buildRow(entry.getKey(), entry.getValue());
            if (row == null || !host.equals(row.get((Object)"host"))) continue;
            return row;
        }
        return null;
    }

    private MonitorDataRow buildRow(ServerId serverId, Object pool) {
        if (pool instanceof AttributeAccess) {
            ConnectionPoolSettings settings = (ConnectionPoolSettings)((AttributeAccess)pool).getLopsFileds()[1];
            MonitorDataRow row = new MonitorDataRow();
            row.put((Object)"host", (Object)serverId.getAddress().toString());
            row.add("maxSize", (Object)settings.getMaxSize());
            row.add("minSize", (Object)settings.getMinSize());
            row.add("maxWaitTimeMs", (Object)settings.getMaxWaitTime(TimeUnit.MILLISECONDS));
            row.add("maxConnectionLifeTimeMs", (Object)settings.getMaxConnectionLifeTime(TimeUnit.MILLISECONDS));
            row.add("maxConnectionIdleTimeMs", (Object)settings.getMaxConnectionIdleTime(TimeUnit.MILLISECONDS));
            ConcurrentPool concurrentPool = (ConcurrentPool)((AttributeAccess)pool).getLopsFileds()[2];
            row.add("availableCount", (Object)concurrentPool.getAvailableCount());
            row.add("inUseCount", (Object)concurrentPool.getInUseCount());
            return row;
        }
        return null;
    }

    public void clear() {
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        for (Map.Entry<ServerId, Object> entry : ConnectionPoolHolder.entrySet()) {
            MonitorDataRow row = this.buildRow(entry.getKey(), entry.getValue());
            if (row == null) continue;
            result.add(row);
        }
        return result;
    }

    public void parseParameters(Map<String, String> parameters) {
    }
}

