/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.ClientObjectHolder;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsContext;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsRestClientCollector;
import java.util.Map;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RestClient;

public class PerformRequestAsyncInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable()) {
                String method;
                String endpoint;
                RestClient client = (RestClient)object;
                Integer num = ClientObjectHolder.getOrRegister(client);
                String clientNum = String.valueOf(num);
                if (args[0] instanceof Request) {
                    Request request = (Request)args[0];
                    endpoint = request.getEndpoint();
                    method = request.getMethod();
                    EsUtils.saveUrlInfoLocalsFromObj(request);
                } else {
                    method = (String)args[0];
                    endpoint = (String)args[1];
                }
                Map<String, Object> context = EsRestClientCollector.onStartAsync(clientNum, EsUtils.convertEndpoint(endpoint), method);
                SpanEvent curSpanEvent = TraceCollector.getSpanEvent();
                SpanEvent spanEvent = curSpanEvent != null && curSpanEvent.getMethod().equals("performRequestOld") ? curSpanEvent : TraceCollector.onStart((String)className, (String)methodName, (String)"EsRestClient");
                context.put("spanEvent", spanEvent);
                context.put("url", endpoint);
                EsContext.TRACE_MAP_LOCAL.set(context);
            }
        }
        catch (Exception performAsyncException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)performAsyncException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally((boolean)false);
            }
        }
        catch (Exception performAsyncException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)performAsyncException);
        }
    }
}

