/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.collector;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.stats.EsClusterStats;
import java.util.Map;

public class EsClusterAggregator
extends SinglePrimaryKeyAggregator<EsClusterStats> {
    public static final String ES_CLUSTER_STATS = "esClusterStats";
    public static final String ES_CLUSTER_START_TIME = "esClusterStart";
    public static final String ES_NODES = "esNodes";

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onStartAsync(String esNodes, Map<String, Object> map) {
        if (!this.isEnable) {
            return;
        }
        EsClusterStats stats = (EsClusterStats)this.getValue(esNodes);
        stats.setOrderedEsNodes(esNodes);
        long startTime = stats.onStart();
        map.put(ES_CLUSTER_STATS, (Object)stats);
        map.put(ES_CLUSTER_START_TIME, startTime);
    }

    public void onErrorAsync(Map<String, Object> map, String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        EsClusterStats stats = (EsClusterStats)((Object)map.get(ES_CLUSTER_STATS));
        if (stats != null) {
            stats.onError(errorTraceId);
        }
    }

    public void onFinallyAsync(Map<String, Object> map) {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        EsClusterStats stats = (EsClusterStats)((Object)map.get(ES_CLUSTER_STATS));
        Long startTime = (Long)map.get(ES_CLUSTER_START_TIME);
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
    }

    protected Class<EsClusterStats> getValueType() {
        return EsClusterStats.class;
    }

    public String getName() {
        return "cluster";
    }

    protected String primaryKey() {
        return ES_NODES;
    }
}

