/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

public class StringUtils {
    public static String stringTruncat(String oldStr, int maxLength, String endWith) {
        if (StringUtils.isBlank(oldStr)) {
            return oldStr;
        }
        if (maxLength < 1) {
            return oldStr;
        }
        if (oldStr.length() > maxLength) {
            String strTmp = oldStr.substring(0, maxLength);
            if (StringUtils.isBlank(endWith)) {
                return strTmp;
            }
            return strTmp + endWith;
        }
        return oldStr;
    }

    public static int string2Int(String value, int defaultValue) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean isBlank(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (!StringUtils.hasLength(str) || !StringUtils.hasLength(sub)) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static boolean hasLength(String str) {
        return StringUtils.hasLength((CharSequence)str);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static boolean hasText(String str) {
        return StringUtils.hasText((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDigit(String str) {
        if (StringUtils.isBlank(str)) {
            return false;
        }
        for (char ch : str.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        int i;
        StringBuilder builder = new StringBuilder();
        if (elements.length == 0) {
            return builder.toString();
        }
        for (i = 0; i < elements.length - 1; ++i) {
            builder.append(elements[i]);
            builder.append(delimiter);
        }
        builder.append(elements[i]);
        return builder.toString();
    }

    public static String joinTxList(CharSequence delimiter, List<String> list) {
        StringBuilder builder = new StringBuilder();
        if (list == null || list.size() == 0) {
            return "";
        }
        for (int i = 0; i < list.size(); ++i) {
            String transactionName;
            boolean isRoot;
            if (i > 0) {
                builder.append(",");
            }
            if (isRoot = (transactionName = list.get(i)).endsWith("-r")) {
                transactionName = transactionName.substring(0, transactionName.length() - 2);
            }
            builder.append(transactionName);
        }
        return builder.toString();
    }
}

