/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.utils;

import com.lubanops.apm.bootstrap.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class InputSafetyChecker {
    public static final String CHARACTER_REGEX = "^[A-Za-z_]+$";
    public static final Pattern CHARACTER_PATTERN = Pattern.compile("^[A-Za-z_]+$");
    public static final String CHARACTER_NUMBER_REGEX = "^[A-Za-z0-9_]+$";
    public static final Pattern CHARACTER_NUMBER_PATTERN = Pattern.compile("^[A-Za-z0-9_]+$");
    public static final String CHARACTER_NUMBER_HYPHEN_REGEX = "^[A-Za-z0-9_\\-]+$";
    public static final Pattern CHARACTER_NUMBER_HYPHEN_PATTERN;
    public static final Pattern DEFAULT_PATTERN;
    private static final String PATH_WHITE_LIST = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890-=[];\\',./ ~!@#$%^&*()_+\"{}|:<>?";

    private InputSafetyChecker() {
    }

    public static void check(String input, String errorMessage) throws IllegalArgumentException {
        if (!DEFAULT_PATTERN.matcher(input).matches()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void check(Pattern pattern, String input, String errorMessage) throws IllegalArgumentException {
        if (!pattern.matcher(input).matches()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static String checkFile(String filePath) {
        if (null == filePath) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block0: for (int i = 0; i < filePath.length(); ++i) {
            for (int j = 0; j < PATH_WHITE_LIST.length(); ++j) {
                if (filePath.charAt(i) != PATH_WHITE_LIST.charAt(j)) continue;
                stringBuffer.append(PATH_WHITE_LIST.charAt(j));
                continue block0;
            }
        }
        return stringBuffer.toString();
    }

    public static String getSafePath(String filePath) {
        File file = new File(filePath);
        String safePath = null;
        try {
            safePath = file.getCanonicalPath();
        }
        catch (IOException e) {
            LogFactory.getLogger().severe("getSafePath IOException");
        }
        return InputSafetyChecker.checkFile(safePath);
    }

    static {
        DEFAULT_PATTERN = CHARACTER_NUMBER_HYPHEN_PATTERN = Pattern.compile(CHARACTER_NUMBER_HYPHEN_REGEX);
    }
}

