/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common.url;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.utils.HarvestUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class UrlOverallAggregator
extends NonePrimaryKeyAggregator {
    private volatile long totalRequestCountOld;
    private volatile long totalRequestTimeOld;
    private volatile long errorCountOld;
    private AtomicLong totalRequestCount = new AtomicLong(0L);
    private AtomicLong totalRequestTime = new AtomicLong(0L);
    private AtomicLong errorCount = new AtomicLong();
    private AtomicInteger satisfiedCount = new AtomicInteger(0);
    private AtomicInteger toleratingCount = new AtomicInteger(0);

    @Override
    public String getName() {
        return "total";
    }

    @Override
    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public void onTotal(long t) {
        this.totalRequestCount.incrementAndGet();
        this.totalRequestTime.addAndGet(t);
    }

    public void onError() {
        this.errorCount.incrementAndGet();
    }

    @Override
    public MonitorDataRow constructItemRow() {
        MonitorDataRow row = new MonitorDataRow();
        this.totalRequestCountOld = HarvestUtil.getMetricCount(this.totalRequestCount, this.totalRequestCountOld, "invokeCount", row);
        long newTotalTime = this.totalRequestTime.get();
        long totalTimeLong = newTotalTime - this.totalRequestTimeOld;
        this.totalRequestTimeOld = newTotalTime;
        if (totalTimeLong > 0L) {
            row.put("totalTime", totalTimeLong / 1000000L);
        } else {
            row.remove("totalTime");
        }
        this.errorCountOld = HarvestUtil.getMetricCount(this.errorCount, this.errorCountOld, "errorCount", row);
        row.add("satisfiedCount", this.satisfiedCount.getAndSet(0));
        row.add("toleratingCount", this.toleratingCount.getAndSet(0));
        return row;
    }

    @Override
    public void clear() {
    }

    @Override
    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> list = new ArrayList<MonitorDataRow>();
        MonitorDataRow row = new MonitorDataRow();
        row.put("invokeCount", this.totalRequestCount.get());
        row.put("totalTime", this.totalRequestTime.get() / 1000000L);
        row.put("errorCount", this.errorCount.get());
        list.add(row);
        return list;
    }

    @Override
    public void parseParameters(Map<String, String> parameters) {
    }

    public void onThreshold(UrlStats stat, long t) {
        if (stat != null) {
            long timeInMills = t / 1000000L;
            int threshold = stat.getThreshold();
            if (timeInMills <= (long)threshold) {
                this.satisfiedCount.incrementAndGet();
            } else if (timeInMills <= (long)(threshold * 4)) {
                this.toleratingCount.incrementAndGet();
            }
        }
    }
}

