/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.collector.api.StatsBaseExtend;
import com.lubanops.apm.bootstrap.collector.interceptor.StatsAroundInterceptor;
import com.lubanops.apm.bootstrap.utils.ConcurrentUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultStats
extends StatsBaseExtend
implements StatsBase,
StatsAroundInterceptor {
    public static final long NANO_TO_MILLI = 1000000L;
    protected final AtomicLong invokeCount = new AtomicLong(0L);
    protected final AtomicLong totalTimeInNano = new AtomicLong(0L);
    protected final AtomicLong maxTime = new AtomicLong(0L);
    protected final AtomicLong errorCount = new AtomicLong(0L);
    protected final AtomicLong exceptionCount = new AtomicLong(0L);
    protected final AtomicInteger runningCount = new AtomicInteger(0);
    protected final AtomicInteger concurrentMax = new AtomicInteger(0);
    protected volatile long invokeCountOld;
    protected volatile long totalTimeInNanoOld;
    protected volatile long errorCountOld;
    protected volatile long exceptionCountOld;

    protected static void merge(MonitorDataRow dataRowFrom, MonitorDataRow dataRowDes) {
        dataRowDes.put("invokeCount", dataRowDes.get("invokeCount") == null ? (Long)dataRowFrom.get("invokeCount") : (Long)dataRowDes.get("invokeCount") + (Long)dataRowFrom.get("invokeCount"));
        dataRowDes.put("totalTime", dataRowDes.get("totalTime") == null ? (Long)dataRowFrom.get("totalTime") : (Long)dataRowDes.get("totalTime") + (Long)dataRowFrom.get("totalTime"));
        dataRowDes.put("maxTime", dataRowDes.get("maxTime") == null ? (Long)dataRowFrom.get("maxTime") : (Long)dataRowDes.get("maxTime") + (Long)dataRowFrom.get("maxTime"));
        dataRowDes.put("errorCount", dataRowDes.get("errorCount") == null ? (Long)dataRowFrom.get("errorCount") : (Long)dataRowDes.get("errorCount") + (Long)dataRowFrom.get("errorCount"));
        if (dataRowFrom.get("concurrentMax") != null) {
            dataRowDes.put("concurrentMax", dataRowDes.get("concurrentMax") == null ? (Integer)dataRowFrom.get("concurrentMax") : (Integer)dataRowDes.get("concurrentMax") + (Integer)dataRowFrom.get("concurrentMax"));
        }
    }

    @Override
    public long onStart() {
        long t = System.nanoTime();
        ConcurrentUtil.setMaxValue(this.concurrentMax, this.runningCount.incrementAndGet());
        this.upLatestUpdateTime();
        return t;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.errorCount.incrementAndGet();
    }

    public void onError() {
        this.errorCount.incrementAndGet();
    }

    @Override
    public boolean onFinally(long timeInNanos) {
        this.invokeCount.incrementAndGet();
        this.runningCount.decrementAndGet();
        this.totalTimeInNano.addAndGet(timeInNanos);
        return ConcurrentUtil.setMaxValue(this.maxTime, timeInNanos);
    }

    public boolean onFinallyNoRunningCount(long timeInNanos) {
        this.invokeCount.incrementAndGet();
        this.totalTimeInNano.addAndGet(timeInNanos);
        return ConcurrentUtil.setMaxValue(this.maxTime, timeInNanos);
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = new MonitorDataRow();
        row.put("invokeCount", this.invokeCount.get());
        row.put("totalTime", this.totalTimeInNano.get() / 1000000L);
        row.put("maxTime", this.maxTime.get() / 1000000L);
        row.put("errorCount", this.errorCount.get());
        row.put("concurrentMax", this.concurrentMax.get());
        row.put("exceptionCount", this.exceptionCount.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest() {
        long invokeCountNew = this.invokeCount.get();
        long invokeCountDelta = invokeCountNew - this.invokeCountOld;
        if (invokeCountDelta > 0L) {
            MonitorDataRow row = new MonitorDataRow();
            row.put("invokeCount", invokeCountDelta);
            long totalTimeInNanoNew = this.totalTimeInNano.get();
            row.put("totalTime", (totalTimeInNanoNew - this.totalTimeInNanoOld) / 1000000L);
            row.put("maxTime", this.maxTime.getAndSet(0L) / 1000000L);
            long errorCountNew = this.errorCount.get();
            row.put("errorCount", errorCountNew - this.errorCountOld);
            long exceptionCountNew = this.exceptionCount.get();
            row.put("exceptionCount", exceptionCountNew - this.exceptionCountOld);
            int concurrentMaxInt = this.concurrentMax.getAndSet(0);
            if (concurrentMaxInt > 0) {
                row.put("concurrentMax", concurrentMaxInt);
            }
            this.invokeCountOld = invokeCountNew;
            this.totalTimeInNanoOld = totalTimeInNanoNew;
            this.errorCountOld = errorCountNew;
            this.exceptionCountOld = exceptionCountNew;
            return row;
        }
        return null;
    }
}

