/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.utils.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultExceptionStats
implements StatsBase {
    private volatile int lastCount;
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicReference<String> message = new AtomicReference();
    private AtomicReference<String> stackTrace = new AtomicReference();
    private AtomicReference<String> content = new AtomicReference();

    public void onThrowable(Throwable t, String content) {
        this.count.incrementAndGet();
        if (this.message.get() == null) {
            this.message.set(t.getMessage());
        }
        if (this.stackTrace.get() == null) {
            String s = ExceptionUtil.getThrowableStackTrace(t, false);
            this.stackTrace.set(s);
        }
        if (this.content.get() == null) {
            this.content.set(content);
        }
    }

    @Override
    public MonitorDataRow getStatus() {
        String ct;
        String st;
        MonitorDataRow row = new MonitorDataRow();
        row.put("count", this.count.get());
        String m = this.message.get();
        if (m != null) {
            row.put("message", m);
        }
        if ((st = this.stackTrace.get()) != null) {
            row.put("stackTrace", st);
        }
        if ((ct = this.content.get()) != null) {
            row.put("content", ct);
        }
        return row;
    }

    @Override
    public MonitorDataRow harvest() {
        int c = this.count.get();
        int delta = c - this.lastCount;
        if (delta > 0) {
            String ct;
            String st;
            MonitorDataRow row = new MonitorDataRow();
            row.put("count", delta);
            this.lastCount = c;
            String m = this.message.getAndSet(null);
            if (m != null) {
                row.put("message", m);
            }
            if ((st = (String)this.stackTrace.getAndSet(null)) != null) {
                row.put("stackTrace", st);
            }
            if ((ct = (String)this.content.getAndSet(null)) != null) {
                row.put("content", ct);
            }
            return row;
        }
        return null;
    }
}

