/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.apm;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.utils.ConcurrentUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class APMStats
implements StatsBase {
    protected AtomicLong sendCount = new AtomicLong(0L);
    protected AtomicLong discardCount = new AtomicLong(0L);
    protected AtomicLong errorCount = new AtomicLong(0L);
    protected AtomicLong maxBytes = new AtomicLong(0L);
    protected AtomicLong sendBytes = new AtomicLong(0L);
    protected AtomicLong discardBytes = new AtomicLong(0L);
    protected AtomicLong errorBytes = new AtomicLong(0L);
    protected AtomicInteger maxQueueSize = new AtomicInteger(0);
    protected AtomicLong sendTotalTime = new AtomicLong(0L);
    protected AtomicLong slowTime = new AtomicLong(0L);

    public void onStart(int queueSize) {
        this.sendCount.incrementAndGet();
        ConcurrentUtil.setMaxValue(this.maxQueueSize, queueSize);
    }

    public void onDiscard(long bytes) {
        this.sendBytes.addAndGet(bytes);
        ConcurrentUtil.setMaxValue(this.maxBytes, bytes);
        this.discardCount.incrementAndGet();
        this.discardBytes.addAndGet(bytes);
    }

    public void onThrowable(long bytes) {
        this.sendBytes.addAndGet(bytes);
        ConcurrentUtil.setMaxValue(this.maxBytes, bytes);
        this.errorCount.incrementAndGet();
        this.errorBytes.addAndGet(bytes);
    }

    public void onFinally(long useTime) {
        this.sendTotalTime.addAndGet(useTime);
        ConcurrentUtil.setMaxValue(this.slowTime, useTime);
    }

    public void onSuccess(long bytes) {
        this.sendBytes.addAndGet(bytes);
        ConcurrentUtil.setMaxValue(this.maxBytes, bytes);
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = new MonitorDataRow();
        row.put("sendCount", this.sendCount.get());
        row.put("discardCount", this.discardCount.get());
        row.put("errorCount", this.errorCount.get());
        row.put("maxBytes", this.maxBytes.get());
        row.put("sendBytes", this.sendBytes.get());
        row.put("discardBytes", this.discardBytes.get());
        row.put("errorBytes", this.errorBytes.get());
        row.put("maxQueueSize", this.maxQueueSize.get());
        row.put("sendTotalTime", this.sendTotalTime.get());
        row.put("slowTime", this.slowTime.get());
        return row;
    }

    public double getSuccessPercent() {
        long cSendCount = this.sendCount.get();
        long cErrorCount = this.errorCount.get();
        if (cSendCount != 0L) {
            return (double)cErrorCount / (double)cSendCount;
        }
        return 0.0;
    }

    public double getSendCount() {
        long cSendCount = this.sendCount.get();
        return cSendCount;
    }

    public long getErrorCount() {
        long cErrorCount = this.errorCount.get();
        return cErrorCount;
    }

    @Override
    public MonitorDataRow harvest() {
        long cSendCount = this.sendCount.getAndSet(0L);
        long cDiscardCountHarvest = this.discardCount.getAndSet(0L);
        long cErrorCount = this.errorCount.getAndSet(0L);
        long cMaxBytes = this.maxBytes.getAndSet(0L);
        long cSendBytes = this.sendBytes.getAndSet(0L);
        long cDiscardBytes = this.discardBytes.getAndSet(0L);
        long cErrorBytes = this.errorBytes.getAndSet(0L);
        long cMaxQueueSize = this.maxQueueSize.getAndSet(0);
        long cSendTotalTime = this.sendTotalTime.getAndSet(0L);
        long cSlowTime = this.slowTime.getAndSet(0L);
        MonitorDataRow row = new MonitorDataRow();
        row.put("sendCount", cSendCount);
        row.put("discardCount", cDiscardCountHarvest);
        row.put("errorCount", cErrorCount);
        row.put("maxBytes", cMaxBytes);
        row.put("sendBytes", cSendBytes);
        row.put("discardBytes", cDiscardBytes);
        row.put("errorBytes", cErrorBytes);
        row.put("maxQueueSize", cMaxQueueSize);
        row.put("sendTotalTime", cSendTotalTime);
        row.put("slowTime", cSlowTime);
        return row;
    }
}

