/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.producer.collector;

import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rocketmq.producer.stats.RocketMqPublishStats;
import java.util.List;

public abstract class RocketMqBasicPublishAggregator
extends MultiPrimaryKeyAggregator<RocketMqPublishStats> {
    protected final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    protected final ThreadLocal<RocketMqPublishStats> statsLocal = new ThreadLocal();
    protected final ThreadLocal<Boolean> errorLocal = new ThreadLocal();

    public void incrementPublishedMsgCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPublishStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementPublishedMsgCount(count);
        }
    }

    public void incrementPublishedBytesCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPublishStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementPublishedBytesCount(count);
        }
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPublishStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
            this.errorLocal.set(Boolean.TRUE);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        RocketMqPublishStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
        this.errorLocal.remove();
    }

    protected abstract List<String> primaryKey();

    public abstract String getName();
}

