/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.httpclient.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HostStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostAggregator
extends SinglePrimaryKeyAggregator<HostStats> {
    protected String primaryKey() {
        return "envId";
    }

    public void onResponseClose(String envId, Long startTime, boolean isError, String hostUri) {
        HostStats hostStats = (HostStats)this.getValue(envId);
        hostStats.setHostUri(hostUri);
        Long endTime = System.nanoTime();
        if (isError) {
            hostStats.onError();
        }
        hostStats.onFinally(endTime - startTime);
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> result = new HashMap<String, List<MonitorDataRow>>();
        if (collected == null || collected.isEmpty()) {
            ArrayList<MonitorDataRow> totalRows = new ArrayList<MonitorDataRow>();
            MonitorDataRow row = new MonitorDataRow();
            row.put((Object)"invokeCount", (Object)0);
            row.put((Object)"errorCount", (Object)0);
            totalRows.add(row);
            result.put("total", totalRows);
            return result;
        }
        SV totalStats = new SV();
        this.buildSV(collected, totalStats);
        List<MonitorDataRow> totalRows = this.buildTotalRows(totalStats);
        result.put("total", totalRows);
        return result;
    }

    private List<MonitorDataRow> buildTotalRows(SV totalStats) {
        ArrayList<MonitorDataRow> totalRows = new ArrayList<MonitorDataRow>();
        MonitorDataRow row = new MonitorDataRow();
        row.put((Object)"invokeCount", (Object)totalStats.invokeCount);
        row.put((Object)"totalTime", (Object)totalStats.totalTime);
        row.put((Object)"errorCount", (Object)totalStats.errorCount);
        row.put((Object)"responseCloseCount", (Object)totalStats.responseCloseCount);
        totalRows.add(row);
        return totalRows;
    }

    private void buildSV(List<MonitorDataRow> collected, SV totalStats) {
        for (MonitorDataRow row : collected) {
            Integer responseCloseCount;
            Long totalTime;
            Long errorCount;
            Long invokeCount = (Long)row.get((Object)"invokeCount");
            if (invokeCount != null) {
                totalStats.invokeCount += invokeCount.longValue();
            }
            if ((errorCount = (Long)row.get((Object)"errorCount")) != null) {
                totalStats.errorCount += errorCount.longValue();
            }
            if ((totalTime = (Long)row.get((Object)"totalTime")) != null) {
                totalStats.totalTime += totalTime.longValue();
            }
            if ((responseCloseCount = (Integer)row.get((Object)"responseCloseCount")) == null) continue;
            totalStats.responseCloseCount += responseCloseCount.intValue();
        }
    }

    protected Class<HostStats> getValueType() {
        return HostStats.class;
    }

    public String getName() {
        return "hostInvocation";
    }

    public static class SV {
        public long invokeCount;
        public long totalTime;
        public long errorCount;
        public int responseCloseCount;
    }
}

