/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.utils;

import com.lubanops.apm.integration.access.HMacAlgorithm;
import com.lubanops.apm.integration.access.HMacSignatureUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class UriUtil {
    private static String encodeString(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    public static String buildUri(String address, String ak, String sk, long instanceId) {
        String ts = String.valueOf(System.currentTimeMillis() / 1000L);
        String signature = HMacSignatureUtil.getHmacSign(ts, sk, HMacAlgorithm.HmacSHA256);
        StringBuilder sb = new StringBuilder();
        sb.append(address);
        sb.append("/access-server/");
        sb.append(UriUtil.encodeString(ak));
        sb.append("/").append(ts).append("/");
        sb.append(signature).append("/").append(instanceId);
        return sb.toString();
    }
}

