/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.transport.websocket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.integration.access.Message;
import com.lubanops.apm.integration.access.outbound.SessionOpenRequest;
import com.lubanops.apm.integration.transport.websocket.future.FutureManagementService;
import com.lubanops.apm.integration.transport.websocket.future.MessageFuture;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;

public abstract class LubanWebSocketClient
extends WebSocketClient {
    private static final Logger LOGGER = LogFactory.getLogger();
    private boolean hasOpenResult = false;
    private CountDownLatch latch = new CountDownLatch(1);
    private boolean openResult = false;
    private final FutureManagementService futureManagementService = FutureManagementService.getInstance();
    private final String uri;

    public LubanWebSocketClient(URI serverUri, String uri) {
        super(serverUri);
        this.uri = uri;
    }

    public void sendAsync(Message message) {
        super.send(message.toBytes());
        LOGGER.log(Level.FINE, "sendAsync,message id:" + message.getMessageId());
    }

    public Message sendSync(Message message) {
        Message response = null;
        MessageFuture future = this.futureManagementService.getFuture(message.getMessageId());
        super.send(message.toBytes());
        response = future.get();
        if (response == null) {
            LOGGER.log(Level.FINE, String.format("got nop response message,id:[%s]", message.getMessageId()));
        } else {
            LOGGER.log(Level.FINE, "got response message, id:" + message.getMessageId());
        }
        return response;
    }

    public void onMessage(String s) {
        LOGGER.log(Level.FINE, "onMessage message:" + s);
    }

    public void onMessage(ByteBuffer buffer) {
        int length = buffer.limit() - buffer.position();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        Message msg = Message.parseBytes(bytes);
        LOGGER.log(Level.FINE, " received message , id:" + msg.getMessageId());
        if (msg.getMessageId() == 0L) {
            LOGGER.log(Level.FINE, " received message , msg" + msg);
        }
        if (msg.getType() == 2) {
            this.futureManagementService.notifyFuture(msg);
        } else if (msg.getType() == 4) {
            this.futureManagementService.notifyFuture(msg);
        } else if (msg.getType() == 5) {
            SessionOpenRequest.SessionOpenHeader sessionOpenHeader = (SessionOpenRequest.SessionOpenHeader)JSON.parseObject((byte[])msg.getHeader(), SessionOpenRequest.SessionOpenHeader.class, (Feature[])new Feature[0]);
            if ("0".equals(sessionOpenHeader.getCode())) {
                this.openResult = true;
            } else {
                this.openResult = false;
                LOGGER.log(Level.SEVERE, "access_session_open_response id:" + msg.getMessageId() + " result:" + sessionOpenHeader.getMsg());
            }
            this.hasOpenResult = true;
            this.latch.countDown();
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "can not enter here" + msg.getMessageId());
        }
    }

    public void onClose(int i, String s, boolean b) {
        LOGGER.log(Level.INFO, "onClose " + s + ", boolean:" + b);
    }

    public void onError(Exception e) {
        LOGGER.log(Level.SEVERE, "on error", (Throwable)e);
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isHasOpenResult(long timeout) {
        try {
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.hasOpenResult;
    }

    public boolean isHasOpenResult() {
        return this.hasOpenResult;
    }

    public void setHasOpenResult(boolean hasOpenResult) {
        this.hasOpenResult = hasOpenResult;
    }

    public boolean getOpenResult() {
        return this.openResult;
    }

    public void setOpenResult(boolean openResult) {
        this.openResult = openResult;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LubanWebSocketClient{");
        sb.append("uri=").append(this.uri);
        sb.append('}');
        return sb.toString();
    }
}

