/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.transport.http;

import com.lubanops.apm.integration.enums.HttpMethod;
import com.lubanops.apm.integration.transport.http.Request;
import com.lubanops.apm.integration.utils.HttpUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public class HttpRequest
implements Request {
    private String method = null;
    private String url = null;
    private String body = null;
    private String fragment = null;
    private Map<String, String> headers = new Hashtable<String, String>();
    private Map<String, List<String>> queryString = new Hashtable<String, List<String>>();

    @Override
    public void setSignature(String signature) {
        this.addHeader("apm2sig", signature);
    }

    public HttpRequestBase generate() throws UnsupportedEncodingException {
        HttpPost httpRequest;
        StringEntity entity;
        if (HttpMethod.POST.name().equals(this.method)) {
            HttpPost postMethod = new HttpPost(this.url);
            if (this.getBody() != null) {
                entity = new StringEntity(this.getBody(), Charset.forName("UTF-8"));
                postMethod.setEntity((HttpEntity)entity);
            }
            httpRequest = postMethod;
        } else if (HttpMethod.PUT.name().equals(this.method)) {
            HttpPut putMethod = new HttpPut(this.url);
            httpRequest = putMethod;
            if (this.getBody() != null) {
                entity = new StringEntity(this.getBody(), Charset.forName("UTF-8"));
                putMethod.setEntity((HttpEntity)entity);
            }
        } else if (HttpMethod.PATCH.name().equals(this.method)) {
            HttpPatch patchMethod = new HttpPatch(this.url);
            httpRequest = patchMethod;
            if (this.getBody() != null) {
                entity = new StringEntity(this.getBody(), Charset.forName("UTF-8"));
                patchMethod.setEntity((HttpEntity)entity);
            }
        } else if (HttpMethod.GET.name().equals(this.method)) {
            httpRequest = new HttpGet(this.url);
        } else if (HttpMethod.DELETE.name().equals(this.method)) {
            httpRequest = new HttpDelete(this.url);
        } else if (HttpMethod.OPTIONS.name().equals(this.method)) {
            httpRequest = new HttpOptions(this.url);
        } else {
            if (!HttpMethod.HEAD.name().equals(this.method)) {
                throw new RuntimeException("Unknown HTTP method name: " + this.method);
            }
            httpRequest = new HttpHead(this.url);
        }
        Map<String, String> requestHeaders = this.getHeaders();
        for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length".toString())) continue;
            String value = requestHeaders.get(entry.getKey());
            httpRequest.addHeader(entry.getKey(), new String(value.getBytes("UTF-8"), "ISO-8859-1"));
        }
        return httpRequest;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.method.toUpperCase());
    }

    public void setMethod(String method) throws Exception {
        if (null == method) {
            throw new Exception("method can not be empty");
        }
        if (!(method.equalsIgnoreCase("post") || method.equalsIgnoreCase("put") || method.equalsIgnoreCase("patch") || method.equalsIgnoreCase("delete") || method.equalsIgnoreCase("get") || method.equalsIgnoreCase("options") || method.equalsIgnoreCase("head"))) {
            throw new Exception("unsupported method");
        }
        this.method = method;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getUrl() {
        StringBuilder sBuilder = new StringBuilder(this.url);
        sBuilder.append("?");
        if (this.queryString.size() > 0) {
            int loop = 0;
            for (Map.Entry<String, List<String>> entry : this.queryString.entrySet()) {
                for (String value : entry.getValue()) {
                    if (loop > 0) {
                        sBuilder.append("&");
                    }
                    sBuilder.append(HttpUtils.urlEncode(entry.getKey(), false));
                    sBuilder.append("=");
                    sBuilder.append(HttpUtils.urlEncode(value, false));
                    ++loop;
                }
            }
        }
        if (this.fragment != null) {
            sBuilder.append("#");
            sBuilder.append(this.fragment);
        }
        return sBuilder.toString();
    }

    public void setUrl(String url) throws Exception {
        if (null != url && !url.trim().isEmpty()) {
            int i = url.indexOf(35);
            if (i >= 0) {
                url = url.substring(0, i);
            }
            if ((i = url.indexOf(63)) >= 0) {
                String query = url.substring(i + 1, url.length());
                for (String item : query.split("&")) {
                    String[] spl = item.split("=", 2);
                    String key = spl[0];
                    String value = "";
                    if (spl.length > 1) {
                        value = spl[1];
                    }
                    if (key.trim().isEmpty()) continue;
                    key = URLDecoder.decode(key, "UTF-8");
                    value = URLDecoder.decode(value, "UTF-8");
                    this.addQueryStringParam(key, value);
                }
                url = url.substring(0, i);
            }
        } else {
            throw new Exception("url can not be empty");
        }
        this.url = url;
    }

    public String getPath() {
        String url = this.url;
        int i = url.indexOf("://");
        if (i >= 0) {
            url = url.substring(i + 3);
        }
        return (i = url.indexOf(47)) >= 0 ? url.substring(i) : "/";
    }

    public String getHost() {
        String url = this.url;
        int i = url.indexOf("://");
        if (i >= 0) {
            url = url.substring(i + 3);
        }
        if ((i = url.indexOf(47)) >= 0) {
            url = url.substring(0, i);
        }
        return url;
    }

    public void addQueryStringParam(String name, String value) throws UnsupportedEncodingException {
        List<String> paramList = this.queryString.get(name);
        if (paramList == null) {
            paramList = new ArrayList<String>();
            this.queryString.put(name, paramList);
        }
        paramList.add(value);
    }

    public Map<String, List<String>> getQueryStringParams() {
        return this.queryString;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) throws Exception {
        if (null == fragment || fragment.trim().isEmpty()) {
            throw new Exception("fragment can not be empty");
        }
        this.fragment = URLEncoder.encode(fragment, "UTF-8");
    }

    public void addHeader(String name, String value) {
        if (null != name && !name.trim().isEmpty()) {
            this.headers.put(name, value);
        }
    }
}

