/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access.outbound;

import com.lubanops.apm.integration.access.Body;
import com.lubanops.apm.integration.access.Header;
import com.lubanops.apm.integration.access.Message;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.utils.JSON;

public class CollectorStatusResponse
extends MessageWrapper {
    private long messageId;
    private CollectorStatusResponseHeader header;
    private CollectorStatusResponseBody body;

    private CollectorStatusResponse() {
    }

    public static CollectorStatusResponse parse(Message message) {
        if (message.getType() != 16) {
            throw new IllegalArgumentException("type not match");
        }
        try {
            CollectorStatusResponse response = new CollectorStatusResponse();
            CollectorStatusResponseHeader header = JSON.parseObject(message.getHeader(), CollectorStatusResponseHeader.class);
            CollectorStatusResponseBody body = JSON.parseObject(message.getBody(), CollectorStatusResponseBody.class);
            response.setMessageId(message.getMessageId());
            response.setHeader(header);
            response.setBody(body);
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to parse msg,msg type:" + message.getType(), e);
        }
    }

    public CollectorStatusResponseHeader getHeader() {
        return this.header;
    }

    public void setHeader(CollectorStatusResponseHeader header) {
        this.header = header;
    }

    public CollectorStatusResponseBody getBody() {
        return this.body;
    }

    public void setBody(CollectorStatusResponseBody body) {
        this.body = body;
    }

    @Override
    public short getType() {
        return 16;
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    @Override
    public byte[] getHeaderBytes() {
        return this.header.toBytes();
    }

    @Override
    public String generateBodyString() {
        return JSON.toJSONString(this.body);
    }

    @Override
    public String getHeadString() {
        return JSON.toJSONString(this.header);
    }

    @Override
    public String getBodyString() {
        throw new UnsupportedOperationException(CollectorStatusResponse.class.getSimpleName() + ".getBodyString() has no implementation.");
    }

    public static class CollectorStatusResponseHeader
    extends Header {
    }

    public static class CollectorStatusResponseBody
    extends Body {
    }
}

