/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access.inbound;

import com.lubanops.apm.integration.access.Message;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.access.inbound.MonitorDataHeader;
import com.lubanops.apm.integration.access.inbound.TxDataBody;
import com.lubanops.apm.integration.access.inbound.TxDataHeader;
import com.lubanops.apm.integration.utils.JSON;

public class TxDataRequest
extends MessageWrapper {
    private TxDataHeader header;
    private TxDataBody body;
    private long messageId;

    public static TxDataRequest parseMessage(Message msg) {
        if (msg.getType() != 17) {
            throw new IllegalArgumentException("type not match");
        }
        try {
            TxDataRequest report = new TxDataRequest();
            TxDataHeader header = JSON.parseObject(msg.getHeader(), TxDataHeader.class);
            TxDataBody body = JSON.parseObject(msg.getBody(), TxDataBody.class);
            report.setMessageId(msg.getMessageId());
            report.setHeader(header);
            report.setBody(body);
            return report;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to parse msg,msg type:" + msg.getType(), e);
        }
    }

    @Override
    public short getType() {
        return 17;
    }

    public static MonitorDataHeader parseHeader(Message msg) {
        MonitorDataHeader header = JSON.parseObject(msg.getHeader(), MonitorDataHeader.class);
        return header;
    }

    @Override
    public byte[] getHeaderBytes() {
        return this.header.toBytes();
    }

    @Override
    public String generateBodyString() {
        return JSON.toJSONString(this.body);
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    public TxDataHeader getHeader() {
        return this.header;
    }

    public void setHeader(TxDataHeader header) {
        this.header = header;
    }

    public TxDataBody getBody() {
        return this.body;
    }

    public void setBody(TxDataBody body) {
        this.body = body;
    }

    @Override
    public String getHeadString() {
        return JSON.toJSONString(this.header);
    }

    @Override
    public String getBodyString() {
        return JSON.toJSONString(this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TxDataRequest{");
        sb.append("header=").append(this.header);
        sb.append(", body=").append(this.body);
        sb.append(", messageId=").append(this.messageId);
        sb.append('}');
        return sb.toString();
    }
}

