/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access.inbound;

import com.lubanops.apm.integration.access.Message;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.access.inbound.MonitorDataBody;
import com.lubanops.apm.integration.access.inbound.MonitorDataHeader;
import com.lubanops.apm.integration.utils.JSON;

public class MonitorDataRequest
extends MessageWrapper {
    private MonitorDataHeader header;
    private MonitorDataBody body;
    private long messageId;

    public static MonitorDataRequest parseMessage(Message msg) {
        if (msg.getType() != 1) {
            throw new IllegalArgumentException("type not match");
        }
        try {
            MonitorDataRequest report = new MonitorDataRequest();
            MonitorDataHeader header = JSON.parseObject(msg.getHeader(), MonitorDataHeader.class);
            MonitorDataBody body = JSON.parseObject(msg.getBody(), MonitorDataBody.class);
            report.setMessageId(msg.getMessageId());
            report.setHeader(header);
            report.setBody(body);
            return report;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to parse msg,msg type:" + msg.getType(), e);
        }
    }

    public static MonitorDataHeader parseHeader(Message msg) {
        MonitorDataHeader header = JSON.parseObject(msg.getHeader(), MonitorDataHeader.class);
        return header;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public byte[] getHeaderBytes() {
        return this.header.toBytes();
    }

    @Override
    public String generateBodyString() {
        return JSON.toJSONString(this.body);
    }

    public MonitorDataHeader getHeader() {
        return this.header;
    }

    public void setHeader(MonitorDataHeader header) {
        this.header = header;
    }

    public MonitorDataBody getBody() {
        return this.body;
    }

    public void setBody(MonitorDataBody body) {
        this.body = body;
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    @Override
    public String getHeadString() {
        return JSON.toJSONString(this.header);
    }

    @Override
    public String getBodyString() {
        return JSON.toJSONString(this.body);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MonitorDataRequest{");
        sb.append("header=").append(this.header);
        sb.append(", body=").append(this.body);
        sb.append(", messageId=").append(this.messageId);
        sb.append('}');
        return sb.toString();
    }
}

