/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access;

import com.lubanops.apm.integration.access.HMacAlgorithm;
import com.lubanops.apm.integration.utils.StringUtil;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMacSignatureUtil {
    public static String getHmacSign(String content, String key, HMacAlgorithm hMacAlgorithm) {
        try {
            SecretKeySpec signinKey = new SecretKeySpec(key.getBytes(), hMacAlgorithm.name());
            Mac mac = Mac.getInstance(hMacAlgorithm.name());
            mac.init(signinKey);
            byte[] rawHmac = mac.doFinal(content.getBytes(Charset.forName("UTF-8")));
            return StringUtil.bytesToString(rawHmac);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("NoSuchAlgorithmException", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("InvalidKeyException", e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("IllegalStateException", e);
        }
    }
}

