/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mqtt.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.bootstrap.plugin.mqtt.collector.MqttClientReceiveAggregator;
import com.lubanops.apm.bootstrap.plugin.mqtt.collector.PahoMsgInvocationAggregator;
import java.util.Map;

public class PahoSubscriberCollector
extends Collector {
    public static final PahoSubscriberCollector INSTANCE = new PahoSubscriberCollector();
    public static final PahoMsgInvocationAggregator MESSAGE_AGGREGATOR = new PahoMsgInvocationAggregator();
    public static final MqttClientReceiveAggregator CLIENT_RECEIVE_AGGREGATOR = new MqttClientReceiveAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    public static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();

    public static void onDeliverMsgStart(String uri) {
        MESSAGE_AGGREGATOR.onStart(uri, "PUBLISH");
    }

    public static void onDeliverMsgFinally(String traceId) {
        MESSAGE_AGGREGATOR.onFinally(traceId, "PahoSubscriber", true);
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public static void onReceivePublishMsg(String clientId, String topic, int bytesCount) {
        CLIENT_RECEIVE_AGGREGATOR.onReceivePublishMsg(clientId, topic, bytesCount);
    }

    public static void setVersion(String version) {
        VERSION_AGGREGATOR.setVersion(version);
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "PahoSubscriber";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)MESSAGE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CLIENT_RECEIVE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

