/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.gaussdb.zenith.interceptor;

import com.huawei.gauss.jdbc.GaussStatement;
import com.huawei.gauss.jdbc.inner.GaussResultSetImpl;
import com.huawei.gauss.jdbc.inner.GaussStatementImpl;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.SqlParserUtil;
import com.lubanops.apm.plugin.gaussdb.zenith.GaussTrace;
import com.lubanops.apm.plugin.gaussdb.zenith.GaussUtils;
import com.lubanops.apm.plugin.gaussdb.zenith.collector.GaussDbCollector;
import java.sql.ResultSet;

public class StatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (GaussDbCollector.INSTANCE.isEnable()) {
                GaussStatementImpl statement = (GaussStatementImpl)args[0];
                String sql = (String)args[1];
                Integer id = GaussUtils.getConnectionId((GaussStatement)statement);
                GaussUtils.onStatementStart(sql, id);
                GaussTrace.onStart(className, methodName, SqlParserUtil.parse((String)sql), sql, id);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (GaussDbCollector.INSTANCE.isEnable()) {
                String sql = (String)args[1];
                GaussUtils.onStatementError(e, sql);
                GaussTrace.onError(e);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (GaussDbCollector.INSTANCE.isEnable()) {
                GaussStatementImpl statement = (GaussStatementImpl)args[0];
                String sql = (String)args[1];
                int readRowCount = 0;
                int updatedRowCount = statement.getUpdateCount();
                ResultSet resultSet = statement.getResultSet();
                if (resultSet instanceof GaussResultSetImpl) {
                    readRowCount = GaussUtils.getReadRows((GaussResultSetImpl)resultSet);
                }
                if ((updatedRowCount -= readRowCount) < 0) {
                    updatedRowCount = 0;
                }
                GaussDbCollector.onConnectionEnd(sql, updatedRowCount, readRowCount);
                GaussDbCollector.onFinally(updatedRowCount, readRowCount);
                GaussTrace.onFinally(updatedRowCount, readRowCount);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
        }
    }
}

