/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jdkhttpclient.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientType;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.AgentUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.lang.instrument.Instrumentation;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.net.www.MessageHeader;

public class JDKHttpClientInterceptor
implements Interceptor {
    private ThreadLocal<Boolean> hasErrorThreadLocal = new ThreadLocal();
    private ThreadLocal<Boolean> isConected = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if (HttpClientCollector.INSTANCE.isEnable()) {
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)object;
                if ("connect".equals(methodName) && object instanceof AttributeAccess) {
                    List txName;
                    String userFlag;
                    Object[] fields = ((AttributeAccess)object).getLopsFileds();
                    Boolean conected = (Boolean)fields[0];
                    MessageHeader userHeaders = (MessageHeader)fields[1];
                    MessageHeader requests = (MessageHeader)fields[2];
                    if (conected != null && conected.booleanValue()) {
                        this.isConected.set(true);
                        return new Object[0];
                    }
                    SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)HttpClientType.Jdkhttpclient.name());
                    URL url = httpURLConnection.getURL();
                    String hostUri = this.getHostUri(url);
                    String requestUri = url.toString();
                    String httpMethod = httpURLConnection.getRequestMethod();
                    Map map = HttpClientCollector.onStartAsync((String)hostUri, (String)requestUri, (String)httpMethod, (String)HttpClientType.Jdkhttpclient.name());
                    this.setAllHeaders(userHeaders, requests, spanEvent, requestUri, httpMethod, map);
                    String gTraceId = TraceCollector.getVirtualTraceId();
                    if (!StringUtils.isBlank((String)gTraceId)) {
                        this.addHeader(userHeaders, requests, Headers.GTRACE_ID.getValue(), gTraceId);
                    }
                    if (!StringUtils.isBlank((String)(userFlag = TraceCollector.getUserFlag()))) {
                        this.addHeader(userHeaders, requests, Headers.USER_FLAG.getValue(), userFlag);
                    }
                    if ((txName = TransactionCollector.getTxName()) != null && txName.size() > 0) {
                        this.addHeader(userHeaders, requests, Headers.TXNANE_ID.getValue(), StringUtils.joinTxList((CharSequence)",", (List)txName));
                    }
                    if (map.size() > 0 && object instanceof TransformAccess) {
                        ((TransformAccess)object).setLopsAttribute((Object)map);
                    }
                }
            }
            catch (Exception e) {
                LogFactory.log((Throwable)e);
            }
        }
        return new Object[0];
    }

    private String getHostUri(URL url) {
        StringBuilder hostUri;
        block3: {
            hostUri = new StringBuilder();
            try {
                URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), null, null, null);
                hostUri.append(uri.toString());
            }
            catch (URISyntaxException e) {
                hostUri.append(url.getProtocol()).append("://");
                if (url.getUserInfo() != null) {
                    hostUri.append(url.getUserInfo()).append("@");
                }
                hostUri.append(url.getHost());
                if (url.getPort() == -1) break block3;
                hostUri.append(":").append(url.getPort());
            }
        }
        return hostUri.toString();
    }

    private void setAllHeaders(MessageHeader userHeaders, MessageHeader requests, SpanEvent spanEvent, String requestUri, String httpMethod, Map<String, Object> map) {
        this.addHeader(userHeaders, requests, Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
        this.addHeader(userHeaders, requests, Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
        this.addHeader(userHeaders, requests, Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
        if (spanEvent != null) {
            spanEvent.addTag("url", requestUri);
            spanEvent.addTag("httpMethod", httpMethod);
            String nextSpanId = spanEvent.generateNextSpanId();
            String traceId = spanEvent.getTraceId();
            this.addHeader(userHeaders, requests, Headers.TRACE_ID.getValue(), traceId);
            this.addHeader(userHeaders, requests, Headers.SPAN_ID.getValue(), nextSpanId);
            this.addHeader(userHeaders, requests, Headers.SOURCE_EVENT_ID.getValue(), spanEvent.getEventId());
            map.put("spanevent", spanEvent);
        }
    }

    private void addHeader(MessageHeader userHeaders, MessageHeader requests, String key, String value) {
        userHeaders.add(key, value);
        requests.add(key, value);
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                if ("connect".equals(methodName)) {
                    Boolean conected = this.isConected.get();
                    if (conected != null && conected.booleanValue()) {
                        return;
                    }
                    this.hasErrorThreadLocal.set(Boolean.TRUE);
                    TraceCollector.onError((Throwable)e);
                    HttpClientCollector.onThrowable((Throwable)e);
                    HttpClientCollector.onResponseClose(null);
                } else if (("getErrorStream".equals(methodName) || "getInputStream".equals(methodName)) && object instanceof TransformAccess) {
                    Object lopsAttribute = ((TransformAccess)object).getLopsAttribute();
                    if (lopsAttribute != null && lopsAttribute instanceof Map) {
                        Map map = (Map)lopsAttribute;
                        Object spanEventObject = map.get("spanevent");
                        String traceId = null;
                        String envId = null;
                        if (spanEventObject != null && spanEventObject instanceof SpanEvent) {
                            SpanEvent spanEvent = (SpanEvent)spanEventObject;
                            traceId = spanEvent.getTraceId();
                            TraceCollector.onError((SpanEvent)spanEvent, (Throwable)e);
                            TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                        }
                        HttpClientCollector.onThrowableAsync((Throwable)e, (Map)map, traceId);
                        HttpClientCollector.onResponseCloseAsync(envId, (Map)map, traceId);
                    }
                    ((TransformAccess)object).setLopsAttribute(null);
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                Object lopsAttribute;
                if ("connect".equals(methodName)) {
                    Boolean conected = this.isConected.get();
                    if (conected != null && conected.booleanValue()) {
                        this.isConected.set(false);
                        return;
                    }
                    Boolean hasError = this.hasErrorThreadLocal.get();
                    if (hasError != null && hasError.booleanValue()) {
                        TraceCollector.onFinally();
                        if (object instanceof TransformAccess) {
                            ((TransformAccess)object).setLopsAttribute(null);
                        }
                    } else {
                        TraceCollector.onFinally((boolean)false);
                    }
                    HttpClientCollector.clear();
                    this.hasErrorThreadLocal.set(null);
                } else if (("getErrorStream".equals(methodName) || "getInputStream".equals(methodName)) && object instanceof TransformAccess && (lopsAttribute = ((TransformAccess)object).getLopsAttribute()) != null && lopsAttribute instanceof Map && result != null && result instanceof TransformAccess) {
                    ((Map)lopsAttribute).put("connection", object);
                    ((TransformAccess)result).setLopsAttribute(lopsAttribute);
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    static {
        Instrumentation instrumentation = AgentUtils.getInstrumentation();
        Module targetModule = JDKHttpClientInterceptor.class.getModule();
        LogFactory.getLogger().log(Level.SEVERE, targetModule.toString());
        Module srcModule = Object.class.getModule();
        LogFactory.getLogger().log(Level.SEVERE, "srcModule: " + srcModule.getName() + srcModule.getPackages() + " targetModule: " + targetModule.getName() + targetModule.getPackages());
        Map<String, Set<Module>> extraOpens = Map.of("sun.net.www", Set.of(targetModule));
        Set<Module> extraReads = Set.of();
        Map<String, Set<Module>> extraExports = Map.of();
        Set<Class<?>> extraUses = Set.of();
        Map<Class<?>, List<Class<?>>> extraProvides = Map.of();
        instrumentation.redefineModule(srcModule, extraReads, extraExports, extraOpens, extraUses, extraProvides);
    }
}

