/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.druid.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class DruidDataSourceAggregator
extends AbstractAggregator {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static final String DRUID_DATA_SOURCE_OBJECT_NAME = "com.alibaba.druid:type=DruidDataSource,*";
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private static final String[] EMPTY_SIGNATURE = new String[0];
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> res = new ArrayList<MonitorDataRow>();
        try {
            Set<ObjectName> druidDataSourceMBeans = this.server.queryNames(new ObjectName(DRUID_DATA_SOURCE_OBJECT_NAME), null);
            if (druidDataSourceMBeans == null || druidDataSourceMBeans.isEmpty()) {
                return res;
            }
            for (ObjectName druidDataSourceMBean : druidDataSourceMBeans) {
                MonitorDataRow row = new MonitorDataRow();
                row.add("url", this.server.getAttribute(druidDataSourceMBean, "Url"));
                row.add("dbType", this.server.getAttribute(druidDataSourceMBean, "DbType"));
                row.add("driverClassName", this.server.getAttribute(druidDataSourceMBean, "DriverClassName"));
                row.add("initialSize", this.server.getAttribute(druidDataSourceMBean, "InitialSize"));
                row.add("minIdle", this.server.getAttribute(druidDataSourceMBean, "MinIdle"));
                row.add("maxIdle", this.server.getAttribute(druidDataSourceMBean, "MaxIdle"));
                row.add("maxActive", this.server.getAttribute(druidDataSourceMBean, "MaxActive"));
                row.add("waitThreadCount", this.server.getAttribute(druidDataSourceMBean, "WaitThreadCount"));
                row.add("maxWaitThreadCount", this.server.getAttribute(druidDataSourceMBean, "MaxWaitThreadCount"));
                row.add("poolingCount", this.server.getAttribute(druidDataSourceMBean, "PoolingCount"));
                row.add("poolingPeak", this.server.getAttribute(druidDataSourceMBean, "PoolingPeak"));
                row.add("activeCount", this.server.getAttribute(druidDataSourceMBean, "ActiveCount"));
                row.add("activePeak", this.server.getAttribute(druidDataSourceMBean, "ActivePeak"));
                row.add("logicConnectCount", this.server.getAttribute(druidDataSourceMBean, "ConnectCount"));
                row.add("maxWait", this.server.getAttribute(druidDataSourceMBean, "MaxWait"));
                row.add("removeAbandoned", (Object)String.valueOf(this.server.getAttribute(druidDataSourceMBean, "RemoveAbandoned")));
                row.add("removeAbandonedCount", this.server.getAttribute(druidDataSourceMBean, "RemoveAbandonedCount"));
                row.add("removeAbandonedTimeoutMillis", this.server.getAttribute(druidDataSourceMBean, "RemoveAbandonedTimeoutMillis"));
                row.add("testWhileIdle", (Object)String.valueOf(this.server.getAttribute(druidDataSourceMBean, "TestWhileIdle")));
                row.add("testOnBorrow", (Object)String.valueOf(this.server.getAttribute(druidDataSourceMBean, "TestOnBorrow")));
                row.add("testOnReturn", (Object)String.valueOf(this.server.getAttribute(druidDataSourceMBean, "TestOnReturn")));
                row.add("minEvictableIdleTimeMillis", this.server.getAttribute(druidDataSourceMBean, "MinEvictableIdleTimeMillis"));
                row.add("timeBetweenEvictionRunsMillis", this.server.getAttribute(druidDataSourceMBean, "TimeBetweenEvictionRunsMillis"));
                this.server.invoke(druidDataSourceMBean, "resetStat", EMPTY_PARAMS, EMPTY_SIGNATURE);
                res.add(row);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Druid harvest: collector monitor data error", (Throwable)e);
        }
        return res;
    }

    public String getName() {
        return "dataSource";
    }
}

