/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.functiongraph.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractPrimaryKeyValueAggregator;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlSlowRequestThreshold;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerAggregator
extends UrlAggregator<UrlStats> {
    private static ThreadLocal<Long> starttimeThreadlocal = new ThreadLocal();
    private static ThreadLocal<UrlStats> serverstatsbaseThreadlocal = new ThreadLocal();
    private static String tag_method = "method";

    public String getName() {
        return "detail";
    }

    protected Class<UrlStats> getValueType() {
        return UrlStats.class;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(tag_method);
    }

    public void parseParameters(Map<String, String> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        Integer slowRequestThreshold = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"functiongraphSlowRequestThreshold", Integer.class);
        this.setSlowRequestThreshold(slowRequestThreshold);
        Stats slowRequestTraceCountStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"functiongraphSlowRequestTraceCountStats", Stats.class);
        this.setSlowRequestTraceCountStats(slowRequestTraceCountStats);
        Stats errorRequestTraceCounStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"functiongraphErrorRequestTraceCounStats", Stats.class);
        this.setErrorRequestTraceCounStats(errorRequestTraceCounStats);
        Stats requestTranceCountStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"functiongraphRequestTranceCountStats", Stats.class);
        this.setRequestTranceCountStats(requestTranceCountStats);
        String sampType = (String)ParameterParseUtil.getParameterValue(parameters, (String)"functiongraphSampleType", String.class);
        String percentage = (String)ParameterParseUtil.getParameterValue(parameters, (String)"functiongraphPercentage", String.class);
        String periodCount = (String)ParameterParseUtil.getParameterValue(parameters, (String)"functiongraphPeriodCount", String.class);
        this.getSampleConfig().setPercentage(percentage);
        this.getSampleConfig().setPeriodCount(periodCount);
        this.getSampleConfig().setSampleType(sampType);
        List urlSlowRequestThresholds = (List)ParameterParseUtil.getParameterValue(parameters, (String)"functiongraphUrlSlowRequestThreshold", List.class, UrlSlowRequestThreshold.class);
        this.setUrlSlowRequestThresholds(urlSlowRequestThresholds);
        int[] range = (int[])ParameterParseUtil.getParameterValue(parameters, (String)"functiongraphRange", int[].class);
        if (range != null && range.length == 5) {
            this.setRanges(range);
        } else {
            this.setRanges(AbstractPrimaryKeyValueAggregator.getDefaultRanges());
        }
    }

    public void onStart(String method) {
        UrlStats stats = (UrlStats)this.getValue(new String[]{method});
        long startTime = stats.onStart();
        starttimeThreadlocal.set(startTime);
        serverstatsbaseThreadlocal.set(stats);
    }

    public void onError() {
        UrlStats stats = serverstatsbaseThreadlocal.get();
        if (stats != null) {
            stats.onError();
        }
    }

    public Long onFinally() {
        UrlStats stats = serverstatsbaseThreadlocal.get();
        if (stats != null) {
            long endTime = System.nanoTime();
            long useTime = endTime - starttimeThreadlocal.get();
            stats.onFinally(useTime);
            starttimeThreadlocal.set(null);
            serverstatsbaseThreadlocal.set(null);
            return useTime;
        }
        return null;
    }

    protected int primaryKeyLength() {
        return 1;
    }

    public String getUrlKey() {
        return tag_method;
    }
}

