/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.premain.agent;

import com.lubanops.apm.bootstrap.commons.ValidatorUtil;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.premain.AgentPremain;
import com.lubanops.apm.premain.utils.LibPathUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ArgumentBuilder {
    public static final String PARAM_CHECKER_DEFAULT = "^[A-Za-z][A-Za-z0-9_-]{0,127}$";
    public static final String PARAM_CHECKER_SUB_BIZ = "^[A-Za-z][A-Za-z0-9_-]{0,127}(/[A-Za-z][A-Za-z0-9_-]{0,127}){0,2}$";
    public static final int PARAM_CHECKER_LENGTH_DEFAULT = 128;
    public static final String DEFAULT_INSTANCE = "default";
    public static final String APP_NAME = "app.name";
    public static final String INSTANCE_NAME = "instance.name";
    public static final String ENV = "env";
    public static final String ENV_TAG = "env.tag";
    public static final String BIZ_PATH = "business";
    public static final String SUB_BUSINESS = "sub.business";
    public static final String ENV_SECRET = "env.secret";
    public static final String LOGPATH = "log.path";
    private String appName;
    private String instanceName;
    private String env;
    private String envTag;
    private String bizPath;
    private String subBusiness;
    private String envSecret;
    private String logPath;

    public Map build(String agentArgs, AgentPremain.LogInitCallback callback) {
        agentArgs = StringUtils.isBlank((String)agentArgs) ? "" : agentArgs.trim();
        this.buildEargerArgs(agentArgs, callback);
        this.buildFromAgentArg(agentArgs);
        this.buildFromConfigFile();
        this.buildFromEnvironment();
        this.checkArgs();
        if (StringUtils.isBlank((String)this.instanceName)) {
            this.instanceName = DEFAULT_INSTANCE;
        }
        return this.buildArgsMap();
    }

    private void buildEargerArgs(String agentArgs, AgentPremain.LogInitCallback callback) {
        if (!StringUtils.isBlank((String)agentArgs)) {
            String[] argArr;
            for (String arg : argArr = agentArgs.split(",")) {
                String[] pair = arg.split("=");
                if ("appName".equals(pair[0])) {
                    this.appName = pair[1];
                }
                if (!"instanceName".equals(pair[0])) continue;
                this.instanceName = pair[1];
            }
        }
        Properties properties = FileUtils.readFilePropertyByPath((String)(LibPathUtils.getAgentPath() + File.separator + "apm.config"));
        if (StringUtils.isBlank((String)this.appName)) {
            this.appName = properties.getProperty(APP_NAME);
        }
        if (StringUtils.isBlank((String)this.instanceName)) {
            this.instanceName = properties.getProperty(INSTANCE_NAME);
        }
        if (StringUtils.isBlank((String)this.appName)) {
            this.appName = System.getProperty("appName");
        }
        if (StringUtils.isBlank((String)this.instanceName)) {
            this.instanceName = System.getProperty("instanceName");
        }
        if (StringUtils.isBlank((String)this.instanceName)) {
            this.instanceName = DEFAULT_INSTANCE;
        }
        this.logPath = properties.getProperty(LOGPATH);
        ValidatorUtil.validate((String)INSTANCE_NAME, (String)this.instanceName, (boolean)false, (int)128, (String)PARAM_CHECKER_DEFAULT);
        callback.initLog(this.appName, this.instanceName, this.logPath);
    }

    private Map buildArgsMap() {
        HashMap<String, String> argMap = new HashMap<String, String>(32);
        argMap.put("appName", this.appName);
        argMap.put("instanceName", this.instanceName);
        argMap.put(ENV, this.env);
        argMap.put("envTag", this.envTag);
        argMap.put(BIZ_PATH, this.bizPath);
        argMap.put("subBusiness", this.subBusiness);
        argMap.put("envSecret", this.envSecret);
        return argMap;
    }

    private void checkArgs() {
        ValidatorUtil.validate((String)ENV, (String)this.env, (boolean)false, (int)128, (String)PARAM_CHECKER_DEFAULT);
        ValidatorUtil.validate((String)ENV_TAG, (String)this.envTag, (boolean)false, (int)128, (String)PARAM_CHECKER_SUB_BIZ);
        ValidatorUtil.validate((String)BIZ_PATH, (String)this.bizPath, (boolean)false, (int)128, (String)PARAM_CHECKER_DEFAULT);
        ValidatorUtil.validate((String)SUB_BUSINESS, (String)this.subBusiness, (boolean)false, (int)128, (String)PARAM_CHECKER_SUB_BIZ);
        ValidatorUtil.validate((String)ENV_SECRET, (String)this.envSecret, (boolean)false, (int)128, (String)PARAM_CHECKER_DEFAULT);
    }

    private void buildFromEnvironment() {
        if (StringUtils.isBlank((String)this.env)) {
            this.env = System.getProperty(ENV);
        }
        if (StringUtils.isBlank((String)this.envTag)) {
            this.envTag = System.getProperty("envTag");
        }
        if (StringUtils.isBlank((String)this.bizPath)) {
            this.bizPath = System.getProperty(BIZ_PATH);
        }
        if (StringUtils.isBlank((String)this.subBusiness)) {
            this.subBusiness = System.getProperty("subBusiness");
        }
        if (StringUtils.isBlank((String)this.envSecret)) {
            this.envSecret = System.getProperty("envSecret");
        }
    }

    private void buildFromConfigFile() {
        Properties properties = FileUtils.readFilePropertyByPath((String)(LibPathUtils.getAgentPath() + File.separator + "apm.config"));
        if (StringUtils.isBlank((String)this.env)) {
            this.env = properties.getProperty(ENV);
        }
        if (StringUtils.isBlank((String)this.envTag)) {
            this.envTag = properties.getProperty(ENV_TAG);
        }
        if (StringUtils.isBlank((String)this.bizPath)) {
            this.bizPath = properties.getProperty(BIZ_PATH);
        }
        if (StringUtils.isBlank((String)this.subBusiness)) {
            this.subBusiness = properties.getProperty(SUB_BUSINESS);
        }
        if (StringUtils.isBlank((String)this.envSecret)) {
            this.envSecret = properties.getProperty(ENV_SECRET);
        }
    }

    private void buildFromAgentArg(String agentArgs) {
        if (!StringUtils.isBlank((String)agentArgs)) {
            String[] argArr;
            for (String arg : argArr = agentArgs.split(",")) {
                String[] pair = arg.split("=");
                if (ENV.equals(pair[0])) {
                    this.env = pair[1];
                }
                if (ENV.equals(pair[0])) {
                    this.env = pair[1];
                }
                if ("envTag".equals(pair[0])) {
                    this.envTag = pair[1];
                }
                if (BIZ_PATH.equals(pair[0])) {
                    this.bizPath = pair[1];
                }
                if ("subBusiness".equals(pair[0])) {
                    this.subBusiness = pair[1];
                }
                if (!"envSecret".equals(pair[0])) continue;
                this.envSecret = pair[1];
            }
        }
    }
}

