/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql5.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql5.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.mysql5.utils.Mysql5Utils;
import com.mysql.jdbc.StatementImpl;

public class StatementExecuteUpdateInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable() && !Mysql5Utils.isConnecting()) {
                StatementImpl statement = (StatementImpl)object;
                String sql = (String)args[0];
                Integer id = PreparedStatementInteceptor.getConnectionId(statement);
                PreparedStatementInteceptor.onStart(sql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)sql, (String)sql, (Integer)id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onFinally(Object object, Object[] args, Object mysql5Result, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                String sql = (String)args[0];
                Integer updateCount = Integer.valueOf(String.valueOf(mysql5Result));
                MysqlCollector.onFinally((int)updateCount, (int)0);
                MysqlTrace.onFinally((int)updateCount, (int)0, null);
                MysqlCollector.onConnectionEnd((String)sql, (int)updateCount, (int)0);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable() && !Mysql5Utils.isConnecting()) {
                String sql = (String)args[0];
                PreparedStatementInteceptor.onError(sql, e);
                MysqlTrace.onError((Throwable)e);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

