/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql5.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql5.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.mysql5.utils.Mysql5Utils;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSetImpl;
import com.mysql.jdbc.StatementImpl;
import java.sql.SQLException;

public class PreparedStatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            PreparedStatement preparedStatement = (PreparedStatement)object;
            if (MysqlCollector.INSTANCE.isEnable()) {
                String originSql = Mysql5Utils.getAsSql(preparedStatement);
                String sql = Mysql5Utils.getSql(preparedStatement);
                Integer id = PreparedStatementInteceptor.getConnectionId((StatementImpl)preparedStatement);
                PreparedStatementInteceptor.onStart(sql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)sql, (String)originSql, (Integer)id);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "PreparedStatementExecuteInterceptor onstart", (Throwable)e);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            MysqlTrace.onError((Throwable)e);
            PreparedStatement preparedStatement = (PreparedStatement)object;
            String sql = Mysql5Utils.getSql(preparedStatement);
            PreparedStatementInteceptor.onError(sql, e);
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            PreparedStatement preparedStatement = (PreparedStatement)object;
            String sql = Mysql5Utils.getSql(preparedStatement);
            int updatedRowCount = 0;
            int readRowCount = 0;
            ResultSetImpl resultSet = null;
            try {
                updatedRowCount = preparedStatement.getUpdateCount();
                resultSet = (ResultSetImpl)preparedStatement.getResultSet();
                if (resultSet != null && (readRowCount = Integer.valueOf(String.valueOf(resultSet.getUpdateCount())).intValue()) == -1) {
                    readRowCount = 1;
                }
            }
            catch (SQLException e) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
            }
            MysqlCollector.onFinally((int)updatedRowCount, (int)readRowCount);
            if (resultSet != null && resultSet instanceof TransformAccess) {
                MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, (TransformAccess)((TransformAccess)resultSet));
            } else {
                MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, null);
            }
            MysqlCollector.onConnectionEnd((String)sql, (int)updatedRowCount, (int)readRowCount);
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
    }
}

