/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.reactornetty.server.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.url.collector.RequestContext;
import com.lubanops.apm.bootstrap.plugin.url.collector.ResponseCache;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlAnalysisUtils;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlSampleFilter;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlStatsCollector;
import com.lubanops.apm.bootstrap.plugin.url.collector.WebContainerType;
import com.lubanops.apm.bootstrap.plugin.url.collector.body.TomcatBodyData;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlStatsConfig;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public class NettyRoutingFilterInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            ServerWebExchange exchange = (ServerWebExchange)args[0];
            ServerHttpRequest request = exchange.getRequest();
            ServerHttpResponse response = exchange.getResponse();
            HashSet uris = (HashSet)exchange.getRequiredAttribute("org.springframework.cloud.gateway.support.ServerWebExchangeUtils.gatewayOriginalRequestUrl");
            URI realUri = request.getURI();
            if (uris != null) {
                Iterator iterator = uris.iterator();
                while (iterator.hasNext()) {
                    URI uri;
                    realUri = uri = (URI)iterator.next();
                    if (uri == null) continue;
                    break;
                }
            }
            if (UrlStatsCollector.INSTANCE.isEnable()) {
                Object[] fields;
                if (args[0] instanceof AttributeAccess && (fields = ((AttributeAccess)args[0]).getLopsFileds())[0] != null && args[0] instanceof TransformAccess) {
                    NettyRoutingFilterInterceptor.saveAsyncData((TransformAccess)args[0]);
                    return null;
                }
                NettyRoutingFilterInterceptor.before(request, response, className, methodName, WebContainerType.ReactorNetty.toString(), realUri);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            TraceCollector.onError((Throwable)e);
            UrlStatsCollector.onThrowable((Throwable)e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ResponseCache.clear();
            if (UrlStatsCollector.INSTANCE.isEnable()) {
                Object[] fields;
                ServerWebExchange exchange = (ServerWebExchange)args[0];
                ServerHttpRequest request = exchange.getRequest();
                ServerHttpResponse response = exchange.getResponse();
                if (args[0] instanceof AttributeAccess && (fields = ((AttributeAccess)args[0]).getLopsFileds())[0] != null && args[0] instanceof TransformAccess) {
                    NettyRoutingFilterInterceptor.clearAsyncData((TransformAccess)args[0]);
                    return;
                }
                HttpStatus statusCode = response.getStatusCode();
                int code = 200;
                if (statusCode != null) {
                    code = statusCode.value();
                }
                NettyRoutingFilterInterceptor.after(request, response, WebContainerType.Tomcat.toString(), code);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public static void before(ServerHttpRequest request, ServerHttpResponse response, String className, String methodName, String type, URI realUri) {
        if (UrlStatsConfig.isBodyDetail()) {
            TomcatBodyData.start();
        }
        HttpHeaders headers = request.getHeaders();
        String cseContext = headers.getFirst(Headers.CSE_CONTEXT.getValue());
        String domainId = headers.getFirst(Headers.DOMAIN_ID.getValue());
        String domainType = headers.getFirst(Headers.DOMAIN_TYPE.getValue());
        String traceId = headers.getFirst(Headers.TRACE_ID.getValue());
        String spanId = headers.getFirst(Headers.SPAN_ID.getValue());
        String sourceEventId = headers.getFirst(Headers.SOURCE_EVENT_ID.getValue());
        String gtraceId = headers.getFirst(Headers.GTRACE_ID.getValue());
        String userFlag = headers.getFirst(Headers.USER_FLAG.getValue());
        String txName = headers.getFirst(Headers.TXNANE_ID.getValue());
        String envId = headers.getFirst(Headers.ENV_ID.getValue());
        if (cseContext != null) {
            Map map = TraceCollector.getTraceMapByCseContext((String)cseContext);
            domainId = TraceCollector.getCseMapValue((Map)map, (String)Headers.DOMAIN_ID.getValue());
            domainType = TraceCollector.getCseMapValue((Map)map, (String)Headers.DOMAIN_TYPE.getValue());
            traceId = TraceCollector.getCseMapValue((Map)map, (String)Headers.TRACE_ID.getValue());
            spanId = TraceCollector.getCseMapValue((Map)map, (String)Headers.SPAN_ID.getValue());
            sourceEventId = TraceCollector.getCseMapValue((Map)map, (String)Headers.SOURCE_EVENT_ID.getValue());
            gtraceId = TraceCollector.getCseMapValue((Map)map, (String)Headers.GTRACE_ID.getValue());
            userFlag = TraceCollector.getCseMapValue((Map)map, (String)Headers.USER_FLAG.getValue());
            txName = TraceCollector.getCseMapValue((Map)map, (String)Headers.TXNANE_ID.getValue());
            envId = TraceCollector.getCseMapValue((Map)map, (String)Headers.ENV_ID.getValue());
        }
        String method = request.getMethod().name();
        String realUrl = realUri.getPath();
        String queryString = realUri.getQuery();
        String targetUrl = UrlAnalysisUtils.getTargetUrl((String)realUrl, null, null, (String)realUri.getHost());
        if (AgentConfigManager.isTxEnable()) {
            TransactionCollector.generateTxList((String)txName, (String)targetUrl, (String)method);
        }
        if (targetUrl != null) {
            UrlStatsCollector.onStart((String)targetUrl, (String)method, (String)envId);
            if (queryString != null) {
                realUrl = realUrl + "?" + queryString;
            }
            StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, traceId, spanId, gtraceId);
            startTraceRequest.setKind(type);
            startTraceRequest.setSource(targetUrl);
            startTraceRequest.setRealSource(realUrl);
            startTraceRequest.setHttpMethod(method);
            startTraceRequest.setSourceEventId(sourceEventId);
            startTraceRequest.setDomainId(domainId);
            startTraceRequest.setDomainType(domainType);
            startTraceRequest.setSampleFilter((SampleFilter)new UrlSampleFilter());
            SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
            NettyRoutingFilterInterceptor.updateSpanEvent(spanEvent, request);
        }
        NettyRoutingFilterInterceptor.setResponseHeader(response, envId, TraceCollector.isSameDomain((String)domainId, (String)domainType));
        TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
    }

    private static void setResponseHeader(ServerHttpResponse response, String envId, boolean isSameDomain) {
        String traceId;
        HttpHeaders headers = response.getHeaders();
        String gTraceId = TraceCollector.getVirtualTraceId();
        if (!StringUtils.isBlank((String)gTraceId)) {
            headers.add(Headers.GTRACE_ID.getValue(), gTraceId);
        }
        if (!StringUtils.isBlank((String)(traceId = TraceCollector.getTraceId()))) {
            headers.add(Headers.TRACE_ID.getValue(), traceId);
        }
        long agentEnvId = IdentityConfigManager.getEnvId();
        if (isSameDomain && agentEnvId > 0L) {
            headers.add(Headers.ENV_ID.getValue(), String.valueOf(agentEnvId));
        }
    }

    private static void updateSpanEvent(SpanEvent spanEvent, ServerHttpRequest request) {
        if (spanEvent != null) {
            String[] paramKeys;
            String[] headKeys;
            String remoteAddr = request.getRemoteAddress().toString();
            TraceCollector.addTag((String)"remoteAddr", (String)remoteAddr);
            for (String headKey : headKeys = UrlStatsConfig.getHeaderKeys()) {
                String value = request.getHeaders().getFirst(headKey);
                TraceCollector.addTag((String)headKey, (String)value);
            }
            for (String paramKey : paramKeys = UrlStatsConfig.getParameterKeys()) {
                String value = (String)request.getQueryParams().getFirst((Object)paramKey);
                TraceCollector.addTag((String)paramKey, (String)value);
            }
            NettyRoutingFilterInterceptor.renderCookie(request);
        }
    }

    public static void after(ServerHttpRequest request, ServerHttpResponse response, String type, int code) {
        String envId = request.getHeaders().getFirst(Headers.ENV_ID.getValue());
        String domainId = request.getHeaders().getFirst(Headers.DOMAIN_ID.getValue());
        String domainType = request.getHeaders().getFirst(Headers.DOMAIN_TYPE.getValue());
        String cseContext = request.getHeaders().getFirst(Headers.CSE_CONTEXT.getValue());
        if (cseContext != null) {
            Map map = TraceCollector.getTraceMapByCseContext((String)cseContext);
            envId = TraceCollector.getCseMapValue((Map)map, (String)Headers.ENV_ID.getValue());
            domainId = TraceCollector.getCseMapValue((Map)map, (String)Headers.DOMAIN_ID.getValue());
            domainType = TraceCollector.getCseMapValue((Map)map, (String)Headers.DOMAIN_TYPE.getValue());
        }
        if (!TraceCollector.isSameDomain((String)domainId, (String)domainType)) {
            envId = null;
        }
        Boolean hasException = TraceCollector.hasException();
        boolean hasError = UrlStatsCollector.onFinally((int)code, (String)envId, (String)request.getURI().toString(), (boolean)hasException);
        SpanEvent spanevent = TraceCollector.getSpanEvent();
        if (spanevent != null) {
            if (UrlStatsConfig.isBodyDetail()) {
                TomcatBodyData.end((String)"UTF-8", (String)"UTF-8", (String)request.getHeaders().getFirst("Content-Encoding"));
            }
            if (UrlStatsConfig.getBizCodeLength() > 0) {
                TomcatBodyData.parseBizError((String)"UTF-8", (String)request.getHeaders().getFirst("Content-Encoding"));
            }
        }
        TraceCollector.onFinally((int)code, (boolean)hasError);
    }

    private static void renderCookie(ServerHttpRequest request) {
        String[] cookieKeys = UrlStatsConfig.getCookieKeys();
        MultiValueMap requestCookiesMap = request.getCookies();
        if (requestCookiesMap != null) {
            for (String cookieKey : cookieKeys) {
                String cookieValue = null;
                Set cookies = requestCookiesMap.keySet();
                for (String cookie : cookies) {
                    if (!cookie.equalsIgnoreCase(cookieKey)) continue;
                    cookieValue = ((HttpCookie)requestCookiesMap.getFirst((Object)cookieKey)).getValue();
                    break;
                }
                if (cookieValue == null) continue;
                TraceCollector.addTag((String)cookieKey, cookieValue);
            }
        }
    }

    public static void saveAsyncData(TransformAccess args) {
        Object context = args.getLopsAttribute();
        if (context != null && context instanceof RequestContext) {
            SpanEvent spanEvent = ((RequestContext)context).getSpanEvent();
            Map map = ((RequestContext)context).getMap();
            List txName = ((RequestContext)context).getTxName();
            String gTraceId = ((RequestContext)context).getgTraceId();
            String userFlag = ((RequestContext)context).getUserFlag();
            args.setLopsAttribute(null);
            TraceCollector.setSpanEvent((SpanEvent)spanEvent);
            TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
            TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(gTraceId);
            UrlStatsCollector.setThreadLocalMap((Map)map);
            TransactionCollector.setTxName((List)txName);
        }
    }

    public static void clearAsyncData(TransformAccess args) {
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        Map map = UrlStatsCollector.getThreadLocalMap();
        List txName = TransactionCollector.getTxName();
        TraceCollector.clear();
        TransactionCollector.clear();
        UrlStatsCollector.clearThreadLocal();
        RequestContext requestContext = new RequestContext();
        requestContext.setSpanEvent(spanEvent);
        requestContext.setMap(map);
        requestContext.setTxName(txName);
        args.setLopsAttribute((Object)requestContext);
    }
}

