/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.log4j2.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.ThreadUtils;
import com.lubanops.apm.plugin.exception.common.stats.ExceptionConfig;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.util.StringMap;

public class Log4jLogEventInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        StringMap contextData = (StringMap)((Log4jLogEvent)object).getContextData();
        if (!contextData.isFrozen()) {
            SpanEvent spanEvent = TraceCollector.getSpanEvent();
            String traceId = null;
            String spanId = null;
            if (spanEvent != null) {
                traceId = spanEvent.getTraceId();
                spanId = spanEvent.getSpanId();
            }
            String gtraceId = TraceCollector.getVirtualTraceId();
            if (traceId != null) {
                contextData.putValue("apm-traceid", (Object)traceId);
                contextData.putValue("apm-spanid", (Object)spanId);
                ThreadUtils.updateThreadName((String)traceId, (Boolean)ExceptionConfig.isLogPrintTrace());
            } else if (ThreadContext.get((String)"apm-traceid") != null) {
                contextData.remove("apm-traceid");
                ThreadUtils.resetThreadName();
            }
            if (gtraceId != null) {
                contextData.putValue("apm-gtraceid", (Object)gtraceId);
            } else if (ThreadContext.get((String)"apm-gtraceid") != null) {
                contextData.remove("apm-gtraceid");
            }
        }
    }
}

