/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cse.utils;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.cse.collector.provider.config.CSEStatsConfig;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.invocation.InvocationStageTrace;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class CSEUtils {
    private static final Logger LOGGER = LogFactory.getLogger();

    public static String getHeader(String key, Invocation invocation) {
        String valueObj = invocation.getContext(key);
        String value = null;
        if (valueObj != null) {
            value = valueObj.toString();
        } else {
            HttpServletRequestEx request = invocation.getRequestEx();
            if (request != null && (value = request.getHeader(key)) == null) {
                String cseContext = request.getHeader(Headers.CSE_CONTEXT.getValue());
                Map map = TraceCollector.getTraceMapByCseContext((String)cseContext);
                value = TraceCollector.getCseMapValue((Map)map, (String)key);
            }
        }
        return value;
    }

    public static void toStringInvocationStageTrace(InvocationStageTrace invocationStageTrace, SpanEvent spanEvent) {
        if (spanEvent != null) {
            Double prepareTime = invocationStageTrace.calcInvocationPrepareTime();
            Double handlersRequestTime = invocationStageTrace.calcHandlersRequestTime();
            Double handlersResponseTime = invocationStageTrace.calcHandlersResponseTime();
            Double clientFiltersRequestTime = invocationStageTrace.calcClientFiltersRequestTime();
            Double sendRequestTime = invocationStageTrace.calcSendRequestTime();
            Double getConnectionTime = invocationStageTrace.calcGetConnectionTime();
            Double writeToBufferTime = invocationStageTrace.calcWriteToBufferTime();
            Double wakeConsumer = invocationStageTrace.calcWakeConsumer();
            Double clientFiltersResponseTime = invocationStageTrace.calcClientFiltersResponseTime();
            Double threadPoolQueueTime = invocationStageTrace.calcThreadPoolQueueTime();
            Double serverFiltersRequestTime = invocationStageTrace.calcServerFiltersRequestTime();
            Double serverFiltersResponseTime = invocationStageTrace.calcServerFiltersResponseTime();
            Double sendResponseTime = invocationStageTrace.calcSendResponseTime();
            CSEUtils.addTag(prepareTime, spanEvent, "prepareTime");
            CSEUtils.addTag(handlersRequestTime, spanEvent, "handlersRequestTime");
            CSEUtils.addTag(handlersResponseTime, spanEvent, "handlersResponseTime");
            CSEUtils.addTag(clientFiltersRequestTime, spanEvent, "clientFiltersRequestTime");
            CSEUtils.addTag(sendRequestTime, spanEvent, "sendRequestTime");
            CSEUtils.addTag(getConnectionTime, spanEvent, "getConnectionTime");
            CSEUtils.addTag(writeToBufferTime, spanEvent, "writeToBufferTime");
            CSEUtils.addTag(wakeConsumer, spanEvent, "wakeConsumer");
            CSEUtils.addTag(clientFiltersResponseTime, spanEvent, "clientFiltersResponseTime");
            CSEUtils.addTag(threadPoolQueueTime, spanEvent, "threadPoolQueueTime");
            CSEUtils.addTag(serverFiltersRequestTime, spanEvent, "serverFiltersRequestTime");
            CSEUtils.addTag(serverFiltersResponseTime, spanEvent, "serverFiltersResponseTime");
            CSEUtils.addTag(sendResponseTime, spanEvent, "sendResponseTime");
        }
    }

    public static void addTag(Double timeUsed, SpanEvent spanEvent, String key) {
        if (timeUsed != null && !Double.isNaN(timeUsed) && !Double.isInfinite(timeUsed)) {
            spanEvent.addTag(key, String.valueOf(new BigDecimal(timeUsed / (double)TimeUnit.MILLISECONDS.toNanos(1L)).setScale(0, 4).longValue()) + "ms");
        }
    }

    public static void collectRequestBody(SpanEvent spanEvent, HttpServletRequestEx requestEx, Invocation invocation) throws Exception {
        if (AgentConfigManager.isCollectBody() && spanEvent != null) {
            Object[] args;
            boolean hasBodyBuffer = false;
            String requestBody = null;
            if (requestEx.getBodyBuffer() != null) {
                try {
                    requestBody = requestEx.getBodyBuffer().toString();
                    hasBodyBuffer = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                args = invocation.toProducerArguments();
            }
            catch (NoSuchMethodError e) {
                args = invocation.getArgs();
            }
            if (!hasBodyBuffer && args != null) {
                StringBuilder requestBodySB = new StringBuilder();
                for (Object arg : args) {
                    String buffer;
                    if (arg == null || arg.getClass().getName().startsWith("org.apache") || (buffer = APIService.getJsonApi().toJSONString(arg)) == null) continue;
                    requestBodySB.append(" " + buffer);
                }
                requestBody = requestBodySB.toString();
            }
            if (requestBody != null) {
                spanEvent.addTag("requestBody", requestBody, AgentConfigManager.getCollectBodyLength());
            }
        }
    }

    public static void collectResponseBody(Invocation invocation, SpanEvent spanEvent, InvocationFinishEvent event) {
        if (AgentConfigManager.isCollectBody() && spanEvent != null) {
            Response response = event.getResponse();
            Object result = response.getResult();
            String responseBody = null;
            if (result != null && result instanceof Throwable) {
                TraceCollector.onError((SpanEvent)spanEvent, (Throwable)((Throwable)result));
                if (result instanceof InvocationException) {
                    result = ((InvocationException)result).getErrorData();
                }
            }
            if (result != null) {
                responseBody = APIService.getJsonApi().toJSONString(result);
            }
            if (!StringUtils.isBlank(responseBody)) {
                spanEvent.addTag("responseBody", responseBody, AgentConfigManager.getCollectBodyLength());
            }
        }
    }

    public static void saveBizCodeToSpanEvent(Response response, SpanEvent spanEvent) {
        int bizCodeLength = CSEStatsConfig.getBizCodeLength();
        String[] bizCodeFields = CSEStatsConfig.getBizCodeFields();
        Set<String> bizCodeRightValues = CSEStatsConfig.getBizCodeRightValues();
        if (bizCodeLength > 0) {
            Object result = response.getResult();
            String resultCode = null;
            for (String field : bizCodeFields) {
                try {
                    Object resultObj = CSEUtils.getResult(field, result);
                    if (resultObj != null) {
                        resultCode = String.valueOf(resultObj);
                        if (!bizCodeRightValues.contains(resultCode)) {
                            spanEvent.setSpanError(true);
                        }
                        if (resultCode.length() > bizCodeLength) {
                            resultCode = resultCode.substring(0, bizCodeLength) + "...";
                        }
                        spanEvent.addTag("bizCode", resultCode);
                        return;
                    }
                }
                catch (NoSuchFieldException resultObj) {
                }
                catch (SecurityException e) {
                    LOGGER.log(Level.SEVERE, "cse error security", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.SEVERE, "cse error argument", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(Level.SEVERE, "cse error illegal access", (Throwable)e);
                }
            }
        }
    }

    private static Object getResult(String fieldKey, Object result) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String[] fieldKeys;
        Field errorFiled = null;
        for (String key : fieldKeys = fieldKey.split("[.]")) {
            if (result == null) {
                return null;
            }
            errorFiled = result.getClass().getDeclaredField(key);
            boolean oldAccessible = errorFiled.isAccessible();
            errorFiled.setAccessible(true);
            result = errorFiled.get(result);
            errorFiled.setAccessible(oldAccessible);
        }
        return result;
    }
}

