/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cse.interceptor;

import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.cse.collector.provider.CSEProviderCollector;
import com.lubanops.apm.plugin.cse.collector.provider.CSESampleFilter;
import com.lubanops.apm.plugin.cse.collector.provider.config.CSEStatsConfig;
import com.lubanops.apm.plugin.cse.interceptor.Handler;
import com.lubanops.apm.plugin.cse.utils.CSEUtils;
import java.util.Map;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationBusinessMethodFinishEvent;
import org.apache.servicecomb.core.event.InvocationBusinessMethodStartEvent;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;

public class EdgeHandler
implements Handler {
    @Override
    public void onInvocationStart(InvocationStartEvent event) {
        try {
            if (CSEProviderCollector.INSTANCE.isEnable()) {
                Invocation edgeInvocation = event.getInvocation();
                RestOperationMeta restOperationMeta = (RestOperationMeta)edgeInvocation.getOperationMeta().getExtData("swaggerRestOperation");
                String uri = restOperationMeta.getAbsolutePath();
                String httpMethod = edgeInvocation.getOperationMeta().getHttpMethod();
                String envId = CSEUtils.getHeader(Headers.ENV_ID.getValue(), edgeInvocation);
                HttpServletRequestEx requestEx = edgeInvocation.getRequestEx();
                String realPathWithQueryStr = null;
                if (requestEx != null) {
                    String realPath;
                    realPathWithQueryStr = realPath = requestEx.getRequestURI();
                    String queryString = requestEx.getQueryString();
                    if (queryString != null && !"".equals(queryString)) {
                        realPathWithQueryStr = realPath + "?" + queryString;
                    }
                }
                String traceId = CSEUtils.getHeader(Headers.TRACE_ID.getValue(), edgeInvocation);
                String gtraceId = CSEUtils.getHeader(Headers.GTRACE_ID.getValue(), edgeInvocation);
                String userFlag = CSEUtils.getHeader(Headers.USER_FLAG.getValue(), edgeInvocation);
                String spanId = CSEUtils.getHeader(Headers.SPAN_ID.getValue(), edgeInvocation);
                String eventId = CSEUtils.getHeader(Headers.SOURCE_EVENT_ID.getValue(), edgeInvocation);
                String domainId = CSEUtils.getHeader(Headers.DOMAIN_ID.getValue(), edgeInvocation);
                String domainType = CSEUtils.getHeader(Headers.DOMAIN_TYPE.getValue(), edgeInvocation);
                StartTraceRequest lubanStartTraceRequest = new StartTraceRequest("CSE", edgeInvocation.getInvocationQualifiedName(), traceId, spanId, gtraceId);
                lubanStartTraceRequest.setKind("CSE");
                lubanStartTraceRequest.setSource(uri);
                lubanStartTraceRequest.setRealSource(realPathWithQueryStr);
                lubanStartTraceRequest.setHttpMethod(httpMethod);
                lubanStartTraceRequest.setSourceEventId(eventId);
                lubanStartTraceRequest.setDomainId(domainId);
                lubanStartTraceRequest.setDomainType(domainType);
                lubanStartTraceRequest.setSampleFilter((SampleFilter)new CSESampleFilter());
                SpanEvent spanEvent = null;
                if (!CSEStatsConfig.isExcludeUrl(uri)) {
                    spanEvent = TraceCollector.onStart((StartTraceRequest)lubanStartTraceRequest);
                    if (!TraceCollector.isSameDomain((String)domainId, (String)domainType)) {
                        envId = null;
                    }
                    CSEProviderCollector.onStart(uri, httpMethod, envId);
                }
                Map<String, Object> map = CSEProviderCollector.getThreadLocalMap();
                edgeInvocation.addLocalContext("lubanopsapmThreadLocalMap", map);
                CSEProviderCollector.clearThreadLocal();
                TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
                this.setContext(spanEvent, edgeInvocation);
                TraceCollector.setSpanEvent(null);
            }
        }
        catch (Throwable ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", ex);
        }
    }

    private void setContext(SpanEvent spanEvent, Invocation edgeInvocation) {
        String userFlag;
        String gTraceId;
        if (spanEvent != null) {
            String nextSpanId = spanEvent.generateNextSpanId();
            spanEvent.setNextSpanId(nextSpanId);
            edgeInvocation.addContext(Headers.TRACE_ID.getValue(), spanEvent.getTraceId());
            edgeInvocation.addContext(Headers.SPAN_ID.getValue(), nextSpanId);
            edgeInvocation.addContext(Headers.SOURCE_EVENT_ID.getValue(), spanEvent.getEventId());
            edgeInvocation.addContext(Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
            edgeInvocation.addContext(Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
        }
        if (!StringUtils.isBlank((String)(gTraceId = TraceCollector.getVirtualTraceId()))) {
            edgeInvocation.addContext(Headers.GTRACE_ID.getValue(), gTraceId);
        }
        if (!StringUtils.isBlank((String)(userFlag = TraceCollector.getUserFlag()))) {
            edgeInvocation.addContext(Headers.USER_FLAG.getValue(), userFlag);
        }
        edgeInvocation.addContext(Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
        edgeInvocation.addLocalContext("lubanopsapmSpanEvent", (Object)spanEvent);
    }

    @Override
    public void onInvocationFinish(InvocationFinishEvent event) {
        try {
            if (CSEProviderCollector.INSTANCE.isEnable()) {
                InvocationFinishEvent edgeInvocationFinishEvent = event;
                int code = edgeInvocationFinishEvent.getResponse().getStatusCode();
                Invocation edgeInvocation = event.getInvocation();
                Map edgeMap = (Map)edgeInvocation.getLocalContext("lubanopsapmThreadLocalMap");
                edgeInvocation.addLocalContext("lubanopsapmThreadLocalMap", null);
                CSEProviderCollector.setThreadLocalMap(edgeMap);
                RestOperationMeta restOperationMeta = (RestOperationMeta)edgeInvocation.getOperationMeta().getExtData("swaggerRestOperation");
                String url = restOperationMeta.getAbsolutePath();
                String envId = CSEUtils.getHeader(Headers.ENV_ID.getValue(), edgeInvocation);
                Boolean hasException = TraceCollector.hasException();
                boolean hasError = CSEProviderCollector.onFinally(code, envId, url, hasException);
                SpanEvent spanEvent = (SpanEvent)edgeInvocation.getLocalContext("lubanopsapmSpanEvent");
                CSEUtils.toStringInvocationStageTrace(edgeInvocation.getInvocationStageTrace(), spanEvent);
                edgeInvocation.addLocalContext("lubanopsapmSpanEvent", null);
                TraceCollector.setSpanEvent((SpanEvent)spanEvent);
                TraceCollector.onFinally((int)code, (boolean)hasError);
            }
        }
        catch (Throwable e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", e1);
        }
    }

    @Override
    public void onInvocationBusinessStart(InvocationBusinessMethodStartEvent event) {
    }

    @Override
    public void onInvocationBusinessFinish(InvocationBusinessMethodFinishEvent event) {
    }
}

