/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.plugin.jetcd.stats.JetcdStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JetcdUnaryRpcAggregator
extends MultiPrimaryKeyAggregator<JetcdStats> {
    public void parseParameters(Map<String, String> parameters) {
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalInvokeCount = 0L;
        long totalErrorCount = 0L;
        long totalTotalTime = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                Long invokeCount = (Long)row.get((Object)"invokeCount");
                Long errorCount = (Long)row.get((Object)"errorCount");
                Long totalTime = (Long)row.get((Object)"totalTime");
                if (invokeCount == null) {
                    invokeCount = 0L;
                }
                if (errorCount == null) {
                    errorCount = 0L;
                }
                if (totalTime == null) {
                    totalTime = 0L;
                }
                totalInvokeCount += invokeCount.longValue();
                totalErrorCount += errorCount.longValue();
                totalTotalTime += totalTime.longValue();
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"invokeCount", (Object)totalInvokeCount);
        totalRow.put((Object)"errorCount", (Object)totalErrorCount);
        totalRow.put((Object)"totalTime", (Object)totalTotalTime);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    public Map<String, Object> onStartAsync(String endpoints, String request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.isEnable) {
            return map;
        }
        JetcdStats stats = (JetcdStats)this.getValue(new String[]{endpoints, request});
        if (stats != null) {
            map.put("startTime", stats.onStart());
            map.put("stats", (Object)stats);
        }
        return map;
    }

    public void onFinallyAsync(Map<String, Object> context, String traceId) {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        JetcdStats stats = (JetcdStats)((Object)context.get("stats"));
        Long startTime = (Long)context.get("startTime");
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(traceId);
        }
    }

    public void onErrorAsync(Map<String, Object> context, String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        JetcdStats stats = (JetcdStats)((Object)context.get("stats"));
        if (stats != null) {
            stats.onError(errorTraceId);
        }
    }

    protected Class<JetcdStats> getValueType() {
        return JetcdStats.class;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("endpoints", "request");
    }

    public String getName() {
        return "unaryRpc";
    }
}

