/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.jetcd.JetcdConfig;
import com.lubanops.apm.plugin.jetcd.collector.JetcdElectionObserveAggregator;
import com.lubanops.apm.plugin.jetcd.collector.JetcdKeepAliveAggregator;
import com.lubanops.apm.plugin.jetcd.collector.JetcdUnaryRpcAggregator;
import com.lubanops.apm.plugin.jetcd.collector.JetcdWatcherAggregator;
import java.util.Map;

public class JetcdCollector
extends Collector {
    public static final JetcdCollector INSTANCE = new JetcdCollector();
    public static final JetcdUnaryRpcAggregator REQUEST_AGGREGATOR = new JetcdUnaryRpcAggregator();
    public static final JetcdWatcherAggregator WATCHER_AGGREGATOR = new JetcdWatcherAggregator();
    public static final JetcdKeepAliveAggregator KEEP_ALIVE_AGGREGATOR = new JetcdKeepAliveAggregator();
    public static final JetcdElectionObserveAggregator ELECTION_OBSERVE_AGGREGATOR = new JetcdElectionObserveAggregator();
    public static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    public static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();
    private static final String JETCD_IS_PARSE_VALUE = "JetcdIsParseValue";

    public static Map<String, Object> onRequestStartAsync(String endpoints, String request) {
        return REQUEST_AGGREGATOR.onStartAsync(endpoints, request);
    }

    public static void onRequestFinallyAsync(Map<String, Object> context, String traceId) {
        if (context == null) {
            return;
        }
        REQUEST_AGGREGATOR.onFinallyAsync(context, traceId);
    }

    public static void onRequestErrorAsync(Map<String, Object> context, String errorTraceId) {
        if (context == null) {
            return;
        }
        REQUEST_AGGREGATOR.onErrorAsync(context, errorTraceId);
    }

    public static void onWatcherStart(String identifier) {
        WATCHER_AGGREGATOR.onStart(identifier);
    }

    public static void onWatcherFinally() {
        WATCHER_AGGREGATOR.onFinally();
    }

    public static void onWatcherError(String errorTraceId) {
        WATCHER_AGGREGATOR.onError(errorTraceId);
    }

    public static void onKeepAliveStart(String identifier) {
        KEEP_ALIVE_AGGREGATOR.onStart(identifier);
    }

    public static void onKeepAliveFinally() {
        KEEP_ALIVE_AGGREGATOR.onFinally();
    }

    public static void onKeepAliveError(String errorTraceId) {
        KEEP_ALIVE_AGGREGATOR.onError(errorTraceId);
    }

    public static void onElectionObserveStart(String identifier) {
        ELECTION_OBSERVE_AGGREGATOR.onStart(identifier);
    }

    public static void onElectionObserveError(String errorTraceId) {
        ELECTION_OBSERVE_AGGREGATOR.onError(errorTraceId);
    }

    public static void onElectionObserveFinally() {
        ELECTION_OBSERVE_AGGREGATOR.onFinally();
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public static void setDriverVersion(String version) {
        VERSION_AGGREGATOR.setVersion(version);
    }

    public void parseParameter(Map<String, String> parameters) {
        try {
            Boolean isParseValue = ParameterParseUtil.getBoolean(parameters, (String)JETCD_IS_PARSE_VALUE);
            JetcdConfig.setParseValue(isParseValue);
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "Jetcd parseParameter failed!", (Throwable)e);
        }
    }

    public String getCollectorName() {
        return "Jetcd";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)REQUEST_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)WATCHER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)KEEP_ALIVE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)ELECTION_OBSERVE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

