/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.exception.common.collector.ExceptionCollector;
import java.security.ProtectionDomain;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jInterceptor
implements Interceptor {
    private String version;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        Logger logger = null;
        if (object instanceof Logger) {
            logger = (Logger)object;
        } else if (object instanceof Category) {
            logger = (Category)object;
        }
        if (logger == null) {
            return null;
        }
        String logName = logger.getName();
        if ("error".equals(methodName) || "fatal".equals(methodName)) {
            String msg = "";
            Throwable th = null;
            for (Object argObj : args) {
                if (argObj instanceof String) {
                    msg = (String)argObj;
                    continue;
                }
                if (!(argObj instanceof Throwable)) continue;
                th = (Throwable)argObj;
            }
            ExceptionCollector.onError((String)logName, (String)("log4j_" + methodName), (Object)msg, th);
        } else if ("log".equals(methodName)) {
            this.logError(args, logName);
        }
        if (this.version == null) {
            this.version = Util.getJarVersionFromProtectionDomain((ProtectionDomain)object.getClass().getProtectionDomain());
            ExceptionCollector.setLog4jVersion((String)this.version);
        }
        return null;
    }

    private void logError(Object[] args, String logName) {
        String msg = "";
        Throwable th = null;
        Priority priority = null;
        org.apache.log4j.Level level = null;
        for (Object arg : args) {
            if (arg instanceof String) {
                msg = (String)arg;
                continue;
            }
            if (arg instanceof Throwable) {
                th = (Throwable)arg;
                continue;
            }
            if (arg instanceof Priority) {
                priority = (Priority)arg;
                continue;
            }
            if (!(arg instanceof org.apache.log4j.Level)) continue;
            level = (org.apache.log4j.Level)arg;
        }
        if (priority != null && (priority.toInt() == 40000 || priority.toInt() == 50000)) {
            ExceptionCollector.onError((String)logName, (String)("log4j2_" + priority.toString()), (Object)msg, (Throwable)th);
        }
        if (level != null && (level.toInt() == 40000 || level.toInt() == 50000)) {
            ExceptionCollector.onError((String)logName, (String)("log4j2_" + level.toString()), (Object)msg, (Throwable)th);
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ExceptionCollector.clearContext();
        }
        catch (Exception exception) {
            LogFactory.getLogger().log(Level.SEVERE, "Log4jInterceptor onFinally", (Throwable)exception);
        }
    }
}

