/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.exception.CommonLogListener;
import com.lubanops.apm.plugin.exception.common.collector.ExceptionCollector;
import java.security.ProtectionDomain;

public class CommonLogInterceptor
implements Interceptor {
    private String version;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (object instanceof TransformAccess) {
                String logName = (String)((TransformAccess)object).getLopsAttribute();
                String flag = CommonLogListener.STRING_STRING_HASH_MAP.get(className);
                String logtype = "cl_" + flag + "_" + methodName;
                if (args.length == 1) {
                    ExceptionCollector.onError((String)logName, (String)logtype, (Object)args[0]);
                } else if (args.length == 2) {
                    ExceptionCollector.onError((String)logName, (String)logtype, (Object)args[0], (Throwable)((Throwable)args[1]));
                }
            }
            if (this.version == null) {
                this.version = Util.getJarVersionFromProtectionDomain((ProtectionDomain)object.getClass().getProtectionDomain());
                ExceptionCollector.setCommonLogVersion((String)this.version);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
        return new Object[0];
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ExceptionCollector.clearContext();
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }
}

