/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.felix.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.HashMap;

public class FelixClassLoaderInterceptor
implements Interceptor {
    private static final String LUBAN_PACKAGE = "com.lubanops.*";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            String bootDelegation;
            HashMap<String, String> configMap = (HashMap<String, String>)args[0];
            if (configMap == null) {
                configMap = new HashMap<String, String>();
            }
            if (StringUtils.isBlank((String)(bootDelegation = (String)configMap.get("org.osgi.framework.bootdelegation")))) {
                configMap.put("org.osgi.framework.bootdelegation", LUBAN_PACKAGE);
            } else if (!bootDelegation.contains(LUBAN_PACKAGE)) {
                configMap.put("org.osgi.framework.bootdelegation", bootDelegation + "," + LUBAN_PACKAGE);
            }
        }
        catch (Throwable e) {
            LogFactory.getLogger().log(Level.WARNING, "FelixClassLoaderInterceptor onStart error:" + e.getMessage());
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

