/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.server.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.plugin.coapcalifornium.client.collector.CoapStatusInfoAggregator;
import com.lubanops.apm.plugin.coapcalifornium.server.collector.CoapClusterAggregator;
import com.lubanops.apm.plugin.coapcalifornium.server.collector.CoapServerAggregator;
import com.lubanops.apm.plugin.coapcalifornium.server.stats.CoapClusterStats;
import com.lubanops.apm.plugin.coapcalifornium.stats.CoapStats;
import java.util.Map;
import org.eclipse.californium.core.coap.CoAP;

public class CoapServerCollector
extends Collector {
    public static final CoapServerCollector INSTANCE = new CoapServerCollector();
    private static final CoapServerAggregator COAP_SERVER_AGGREGATOR = new CoapServerAggregator();
    private static final CoapStatusInfoAggregator COAP_STATUS_INFO_AGGREGATOR = new CoapStatusInfoAggregator();
    private static final CoapClusterAggregator COAP_CLUSTER_AGGREGATOR = new CoapClusterAggregator();
    private static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();

    public static void setVersion(String version) {
        VERSION_AGGREGATOR.setVersion(version);
    }

    public static Map<String, Object> onStart(String url, String methodType, String requestType, String envId) {
        Map<String, Object> collectorContext = COAP_SERVER_AGGREGATOR.onStart(url, methodType, requestType);
        COAP_CLUSTER_AGGREGATOR.onStart(collectorContext, envId);
        return collectorContext;
    }

    public static void onError(CoapStats stats, CoapClusterStats clusterStats, CoAP.ResponseCode code, String traceId) {
        COAP_SERVER_AGGREGATOR.onError(stats, traceId);
        COAP_CLUSTER_AGGREGATOR.onError(clusterStats, code);
    }

    public static void onFinally(CoapStats stats, CoapClusterStats clusterStats, Long startTime, String traceId) {
        COAP_SERVER_AGGREGATOR.onFinally(stats, startTime, traceId);
        COAP_CLUSTER_AGGREGATOR.onFinally(clusterStats, startTime);
    }

    public static void onStatusInfo(String url, String statusInfo) {
        COAP_STATUS_INFO_AGGREGATOR.onStatusInfo(url, statusInfo);
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "CoapServer";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)COAP_SERVER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)COAP_STATUS_INFO_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)COAP_CLUSTER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

