/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.client.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.coapcalifornium.CoapUtils;
import com.lubanops.apm.plugin.coapcalifornium.client.collector.CoapClientCollector;
import com.lubanops.apm.plugin.coapcalifornium.stats.CoapStats;
import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;

public class RequestSetResponseInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (CoapClientCollector.INSTANCE.isEnable() && object instanceof Request && args[0] != null && args[0] instanceof Response) {
                Request request = (Request)object;
                if (request.getType() == CoAP.Type.NON) {
                    return;
                }
                Response response = (Response)args[0];
                CoAP.ResponseCode code = response.getCode();
                boolean isSuccess = CoAP.ResponseCode.isSuccess((CoAP.ResponseCode)code);
                String statusInfo = code.toString();
                OptionSet optionSet = response.getOptions();
                String envId = null;
                List arbitraryOptions = optionSet.getOthers();
                for (Option option : arbitraryOptions) {
                    if (option.getNumber() != 1001) continue;
                    envId = option.getStringValue();
                }
                SpanEvent spanEvent = (SpanEvent)CoapUtils.getFromLopsAttribute(object, "spanEvent");
                Map clientContext = (Map)CoapUtils.getFromLopsAttribute(object, "clientCollectorContext");
                CoapStats stats = (CoapStats)((Object)clientContext.get("statsBase"));
                Long startTime = (Long)clientContext.get("startTime");
                CoapClientCollector.conRequestOnResponseClose(isSuccess, stats, startTime, envId, spanEvent == null ? null : spanEvent.getTraceId());
                CoapClientCollector.onStatusInfo(isSuccess, statusInfo, request.getURI(), stats, spanEvent == null ? null : spanEvent.getTraceId());
                if (spanEvent != null) {
                    String codeStr = code.toString();
                    int statusCode = CoapUtils.getCoapCodeInInt(codeStr);
                    spanEvent.setCode(statusCode);
                    spanEvent.setSpanError(!isSuccess);
                    spanEvent.addTag("statusInfo", codeStr);
                    TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

