/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.jvm;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.collector.jvm.JVMClassLoadingAggregator;
import com.lubanops.apm.plugin.collector.jvm.JVMCompileAggregator;
import com.lubanops.apm.plugin.collector.jvm.JVMCpuAggregator;
import com.lubanops.apm.plugin.collector.jvm.JVMMemoryAggregator;
import com.lubanops.apm.plugin.collector.jvm.JVMMemoryPoolAggregator;
import com.lubanops.apm.plugin.collector.jvm.JVMThreadAggregator;
import java.util.Map;

public class JVMCollector
extends Collector {
    public static final JVMCollector INSTANCE = new JVMCollector();
    private static final JVMCpuAggregator JVM_CPU_AGGREGATOR = new JVMCpuAggregator();
    private static final JVMMemoryAggregator JVM_MEMORY_AGGREGATOR = new JVMMemoryAggregator();
    private static final JVMMemoryPoolAggregator JVM_MEMORY_POOL_AGGREGATOR = new JVMMemoryPoolAggregator();
    private static final JVMThreadAggregator JVM_THREAD_AGGREGATOR = new JVMThreadAggregator();
    private static final JVMCompileAggregator JVM_COMPILE_AGGREGATOR = new JVMCompileAggregator();
    private static final JVMClassLoadingAggregator JVM_CLASS_LOADING_AGGREGATOR = new JVMClassLoadingAggregator();

    public static JVMCollector getInstance() {
        return INSTANCE;
    }

    public String getCollectorName() {
        return "JVM";
    }

    public void parseParameter(Map<String, String> parameters) {
        Integer stackThreshold = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"stackThreshold", Integer.class);
        ConfigManager.setStackThreshold((Integer)stackThreshold);
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)JVM_CPU_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)JVM_MEMORY_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)JVM_MEMORY_POOL_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)JVM_THREAD_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)JVM_COMPILE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)JVM_CLASS_LOADING_AGGREGATOR);
        INSTANCE.register();
    }
}

