/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.postgresql.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.postgresql.PgUtils;
import com.lubanops.apm.plugin.postgresql.PgsqlTrace;
import com.lubanops.apm.plugin.postgresql.collector.PgsqlCollector;
import java.util.List;
import org.postgresql.core.CachedQuery;
import org.postgresql.core.ParameterList;
import org.postgresql.jdbc.PgResultSet;
import org.postgresql.jdbc.PgStatement;

public class StatementExecuteInternalInterceptor
implements Interceptor {
    public Object[] onStart(Object statementObject, Object[] args, String className, String methodName) {
        try {
            if (PgsqlCollector.INSTANCE.isEnable()) {
                PgStatement statement = (PgStatement)statementObject;
                CachedQuery cachedQuery = (CachedQuery)args[0];
                Object key = cachedQuery.key;
                String sql = "Unknown";
                if (key instanceof String) {
                    sql = (String)key;
                } else if (key instanceof AttributeAccess) {
                    sql = String.valueOf(((AttributeAccess)key).getLopsFileds()[0]);
                }
                String originSql = null;
                if (PgsqlCollector.CONFIG.isParseOriginSql()) {
                    originSql = cachedQuery.query.toString((ParameterList)args[1]);
                }
                Integer id = PgUtils.getConnectionId(statement);
                PgUtils.onStatementStart(sql, id);
                PgsqlTrace.onStart(className, methodName, sql, originSql, id);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "StatementExecuteInterceptor onStart error", (Throwable)stmtExecuteException);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (PgsqlCollector.INSTANCE.isEnable()) {
                CachedQuery cachedQuery = (CachedQuery)args[0];
                String sql = cachedQuery.query.getNativeSql();
                PgUtils.onStatementError(sql, e);
                PgsqlTrace.onError(e);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (PgsqlCollector.INSTANCE.isEnable()) {
                PgStatement statement = (PgStatement)object;
                CachedQuery cachedQuery = (CachedQuery)args[0];
                String sql = cachedQuery.query.getNativeSql();
                int readRowCount = 0;
                int updatedRowCount = statement.getUpdateCount();
                PgResultSet resultSet = (PgResultSet)statement.getResultSet();
                if (resultSet instanceof AttributeAccess) {
                    readRowCount = ((List)((AttributeAccess)resultSet).getLopsFileds()[0]).size();
                }
                PgsqlCollector.onConnectionEnd(sql, updatedRowCount, readRowCount);
                PgsqlCollector.onFinally(updatedRowCount, readRowCount);
                PgsqlTrace.onFinally(updatedRowCount, readRowCount);
            }
        }
        catch (Exception stmtExecuteException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)stmtExecuteException);
        }
    }
}

