/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.kafka.collector.aggregator;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.kafka.collector.KafkaHelper;
import com.lubanops.apm.bootstrap.plugin.kafka.utils.KafkaUtils;
import com.lubanops.apm.bootstrap.plugin.kafka.utils.MbeanUtils;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class KafkaConsumerPartitionAggregator
extends AbstractAggregator {
    private static final Logger LOGGER = LogFactory.getLogger();
    private MBeanServer server;

    public String getName() {
        return "partition";
    }

    private MBeanServer getServer() {
        if (this.server == null) {
            this.server = ManagementFactory.getPlatformMBeanServer();
        }
        return this.server;
    }

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        HashMap<String, MonitorDataRow> resultMap = new HashMap<String, MonitorDataRow>();
        try {
            ObjectName objName = new ObjectName("kafka.consumer:type=consumer-fetch-manager-metrics,client-id=*,topic=*,partition=*");
            Set<ObjectName> nn = this.getServer().queryNames(objName, null);
            int count = 0;
            for (ObjectName on : nn) {
                MonitorDataRow map;
                if (++count > 100) break;
                String clientId = on.getKeyProperty("client-id");
                String seqId = KafkaHelper.CONSUMERINFO.getReformatIdSeq(clientId);
                String ips = KafkaHelper.CONSUMERINFO.getIp(clientId);
                if (ips == null) continue;
                String topic = on.getKeyProperty("topic");
                String partition = on.getKeyProperty("partition");
                if (seqId != null) {
                    String reformattedIdPrefix = clientId.substring(0, clientId.lastIndexOf("-") + 1);
                    String reformattedId = reformattedIdPrefix + "{sequenceId}" + "|" + ips;
                    String resultMapKey = reformattedId + "|" + topic + "_" + partition;
                    map = (MonitorDataRow)resultMap.get(resultMapKey);
                    if (map == null) {
                        map = new MonitorDataRow();
                        map.put((Object)"id", (Object)reformattedId);
                        map.put((Object)"partition", (Object)(topic + "_" + partition));
                        resultMap.put(resultMapKey, map);
                    }
                    this.setDataCumulated(map, on, clientId, seqId);
                    continue;
                }
                map = new MonitorDataRow();
                map.put((Object)"id", (Object)(clientId + "|" + ips));
                map.put((Object)"partition", (Object)(topic + "_" + partition));
                this.setData(map, on);
                result.add(map);
            }
            result.addAll(resultMap.values());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "collector partition monitor data failed", (Throwable)e);
        }
        return result;
    }

    private void setData(MonitorDataRow row, ObjectName objName) {
        try {
            row.put((Object)"recordsLagAvg", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "records-lag-avg"));
            row.put((Object)"recordsLagMax", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "records-lag-max"));
            row.put((Object)"recordsLag", (Object)MbeanUtils.getIntValue(this.getServer(), objName, "records-lag"));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "collector topic monitor data failed", (Throwable)e);
        }
    }

    private void setDataCumulated(MonitorDataRow row, ObjectName objName, String clientId, String seqId) {
        try {
            KafkaUtils.appendSeqId(row, seqId);
            Double cumulatedRecordsLag = KafkaUtils.getRowValOrZero(row, "recordsLag");
            Double cumulatedRecordsLagAvg = KafkaUtils.getRowValOrZero(row, "recordsLagAvg");
            Double cumulatedRecordsLagMax = KafkaUtils.getRowValOrZero(row, "recordsLagMax");
            row.put((Object)"recordsLag", (Object)KafkaUtils.getSum(cumulatedRecordsLag, MbeanUtils.getIntValue(this.getServer(), objName, "records-lag")));
            row.put((Object)"recordsLagAvg", (Object)KafkaUtils.getRoughAvg(cumulatedRecordsLagAvg, MbeanUtils.getIntValue(this.getServer(), objName, "records-lag-avg")));
            row.put((Object)"recordsLagMax", (Object)KafkaUtils.getMax(cumulatedRecordsLagMax, MbeanUtils.getIntValue(this.getServer(), objName, "records-lag-max")));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "collector topic monitor data failed", (Throwable)e);
        }
    }

    public void clear() {
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        Double totalRecordsLag = 0.0;
        for (MonitorDataRow row : collected) {
            if (row == null || row.get((Object)"recordsLag") == null) continue;
            totalRecordsLag = totalRecordsLag + (Double)row.get((Object)"recordsLag");
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"recordsLag", (Object)totalRecordsLag);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }
}

