/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class DubboResultCodeStats
implements StatsBase {
    private static final String FIELD_RESULT_CODE_COUNT = "count";
    private static final String FIELD_LAST_METHOD = "lastMethod";
    private AtomicLong count = new AtomicLong(0L);
    private AtomicReference<String> lastMethod = new AtomicReference();
    private long countOld;

    public void onFinally(String method) {
        this.count.getAndIncrement();
        this.lastMethod.set(method);
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow dataRow = new MonitorDataRow();
        dataRow.put((Object)FIELD_RESULT_CODE_COUNT, (Object)this.count.get());
        dataRow.put((Object)FIELD_LAST_METHOD, (Object)this.lastMethod.get());
        return dataRow;
    }

    public MonitorDataRow harvest() {
        MonitorDataRow dataRow = new MonitorDataRow();
        long countNew = this.count.get();
        dataRow.put((Object)FIELD_RESULT_CODE_COUNT, (Object)(countNew - this.countOld));
        dataRow.put((Object)FIELD_LAST_METHOD, (Object)this.lastMethod.get());
        this.countOld = countNew;
        return dataRow;
    }
}

