/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.senondversion.interceptor;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.FutureStatsAccessor;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.Tags;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.dubbo.collector.common.TransformAccessRequest;
import com.lubanops.apm.plugin.dubbo.collector.constant.DubboTags;
import com.lubanops.apm.plugin.dubbo.collector.consumer.DubboConsumerCollector;
import com.lubanops.apm.plugin.dubbo.collector.filter.DubboProviderSampleFilter;
import com.lubanops.apm.plugin.dubbo.collector.provider.DubboProviderCollector;
import com.lubanops.apm.plugin.dubbo.collector.utils.DubboCollectorUtil;
import com.lubanops.apm.plugin.dubbo.senondversion.utils.InterceptorAssist;

public class MonitorFilterInvokeInterceptor
implements Interceptor {
    public static final String CONSUMER_TAG = "DUBBO_CONSUMER";
    public static final String PROVIDER_TAG = "DUBBO_PROVIDER";

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        Invoker invoker = (Invoker)args[0];
        Invocation invocation = (Invocation)args[1];
        if (InterceptorAssist.isEnable(invoker)) {
            String side = invoker.getUrl().getParameter("side");
            String interfaceName = invoker.getInterface().getName();
            String group = invoker.getUrl().getParameter("group");
            String version = invoker.getUrl().getParameter("version");
            String serviceUniqueName = DubboCollectorUtil.buildServiceKey(interfaceName, group, version);
            String method = RpcUtils.getMethodName((Invocation)invocation);
            String protocol = invoker.getUrl().getProtocol();
            String application = invoker.getUrl().getParameter("application");
            String apmServiceType = "consumer".equals(invoker.getUrl().getParameter("side")) ? CONSUMER_TAG : PROVIDER_TAG;
            String source = DubboCollectorUtil.buildSourceKey(serviceUniqueName, method);
            SpanEvent apmSpanEvent = "consumer".equals(invoker.getUrl().getParameter("side")) ? this.processConsumer(className, methodName, invocation, serviceUniqueName, method, apmServiceType, source) : this.processProvider(className, methodName, invocation, serviceUniqueName, method, apmServiceType, source);
            this.transformAccess(invoker, invocation, new TransformAccessRequest(side, serviceUniqueName, method, protocol, application, apmSpanEvent));
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        Invoker invoker = (Invoker)args[0];
        Invocation invocation = (Invocation)args[1];
        if (InterceptorAssist.isEnable(invoker) && invocation instanceof TransformAccess) {
            TransformAccess transformAccess = (TransformAccess)invocation;
            FutureStatsAccessor futureStatsAccessor = (FutureStatsAccessor)transformAccess.getLopsAttribute();
            if (futureStatsAccessor == null || futureStatsAccessor.getSpanEvent() == null) {
                return;
            }
            this.doError(futureStatsAccessor, invoker, invocation, e);
        }
    }

    public void onFinally(Object object, Object[] args, Object invokeResult, String className, String methodName) {
        Result result = (Result)invokeResult;
        Invoker invoker = (Invoker)args[0];
        Invocation invocation = (Invocation)args[1];
        if (InterceptorAssist.isEnable(invoker) && invocation instanceof TransformAccess) {
            String apmRemoteEnvId;
            TransformAccess transformAccess = (TransformAccess)invocation;
            FutureStatsAccessor futureStatsAccessor = (FutureStatsAccessor)transformAccess.getLopsAttribute();
            if (futureStatsAccessor == null || futureStatsAccessor.getSpanEvent() == null) {
                return;
            }
            SpanEvent spanEvent = futureStatsAccessor.getSpanEvent();
            if (!spanEvent.getHasError() && result.hasException()) {
                this.doError(futureStatsAccessor, invoker, invocation, result.getException());
            }
            String apmTraceId = spanEvent.getTraceId();
            if (spanEvent.isAsync()) {
                spanEvent.addTag(Tags.asyncTimeUsed.name(), String.valueOf(System.currentTimeMillis() - spanEvent.getStartTime()));
            }
            if (!spanEvent.getHasError()) {
                spanEvent.setCode(200);
            }
            String string = apmRemoteEnvId = "consumer".equals(invoker.getUrl().getParameter("side")) ? invoker.getUrl().getParameter(Headers.ENV_ID.getValue()) : invocation.getAttachment(Headers.ENV_ID.getValue());
            if ("consumer".equals(invoker.getUrl().getParameter("side"))) {
                DubboConsumerCollector.onResponse(futureStatsAccessor.getStartTime(), apmTraceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), apmRemoteEnvId, !spanEvent.getHasError());
                TraceCollector.onFinally();
            } else {
                DubboProviderCollector.onResponse(futureStatsAccessor.getStartTime(), apmTraceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), apmRemoteEnvId, !spanEvent.getHasError());
                String apmResult = String.valueOf(result.getValue());
                if (apmResult != null && apmResult.length() > 0) {
                    spanEvent.addTag("result", apmResult, DubboProviderCollector.INSTANCE.getInvocationLength());
                }
                TraceCollector.onFinally((int)(result.hasException() ? 500 : 200), (boolean)result.hasException());
            }
        }
    }

    private void transformAccess(Invoker invoker, Invocation invocation, TransformAccessRequest transformAccessRequest) {
        TransformAccess transformAccess = (TransformAccess)invocation;
        FutureStatsAccessor futureStatsAccessor = new FutureStatsAccessor();
        transformAccess.setLopsAttribute((Object)futureStatsAccessor);
        futureStatsAccessor.setServiceName(transformAccessRequest.getServiceUniqueName());
        futureStatsAccessor.setMethod(transformAccessRequest.getMethod());
        futureStatsAccessor.setStartTime(System.nanoTime());
        if (transformAccessRequest.getApmSpanEvent() != null) {
            transformAccessRequest.getApmSpanEvent().addTag("serviceUniqueName", transformAccessRequest.getServiceUniqueName());
            transformAccessRequest.getApmSpanEvent().addTag("method", transformAccessRequest.getMethod());
            transformAccessRequest.getApmSpanEvent().addTag("side", transformAccessRequest.getSide());
            transformAccessRequest.getApmSpanEvent().addTag("protocol", transformAccessRequest.getProtocol());
            transformAccessRequest.getApmSpanEvent().addTag("application", transformAccessRequest.getApplication());
            if (RpcUtils.isAsync((URL)invoker.getUrl(), (Invocation)invocation)) {
                transformAccessRequest.getApmSpanEvent().setAsync(true);
            } else {
                transformAccessRequest.getApmSpanEvent().setAsync(false);
            }
            if (RpcUtils.isOneway((URL)invoker.getUrl(), (Invocation)invocation)) {
                transformAccessRequest.getApmSpanEvent().addTag("oneway", "true");
            } else {
                transformAccessRequest.getApmSpanEvent().addTag("oneway", "false");
            }
            futureStatsAccessor.setSpanEvent(transformAccessRequest.getApmSpanEvent());
        }
    }

    private SpanEvent processProvider(String className, String methodName, Invocation invocation, String serviceUniqueName, String method, String apmServiceType, String source) {
        String apmDomainId = invocation.getAttachment(Headers.DOMAIN_ID.getValue());
        String apmDomainType = invocation.getAttachment(Headers.DOMAIN_TYPE.getValue());
        String apmTraceId = invocation.getAttachment(Headers.TRACE_ID.getValue());
        String apmSpanId = invocation.getAttachment(Headers.SPAN_ID.getValue());
        String apmEnvId = invocation.getAttachment(Headers.ENV_ID.getValue());
        String apmGTraceId = null;
        if (StringUtils.isBlank((String)apmTraceId)) {
            apmGTraceId = invocation.getAttachment(Headers.GTRACE_ID.getValue());
        }
        String userFlag = invocation.getAttachment(Headers.USER_FLAG.getValue());
        DubboProviderCollector.onStart(serviceUniqueName, method);
        StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, apmTraceId, apmSpanId, apmGTraceId);
        startTraceRequest.setKind(apmServiceType);
        startTraceRequest.setSource(source);
        startTraceRequest.setRealSource(source);
        startTraceRequest.setSourceEventId(apmEnvId);
        startTraceRequest.setDomainId(apmDomainId);
        startTraceRequest.setDomainType(apmDomainType);
        startTraceRequest.setSampleFilter((SampleFilter)new DubboProviderSampleFilter());
        SpanEvent apmSpanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
        TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
        if (apmSpanEvent != null) {
            String apmAttachments;
            String apmArguments;
            apmSpanEvent.addTag("url", source);
            if (DubboProviderCollector.getInstance().isInvocationDetail() && (apmArguments = String.valueOf(invocation.getArguments())) != null && apmArguments.length() > 0) {
                apmSpanEvent.addTag(DubboTags.arguments.name(), apmArguments, DubboProviderCollector.getInstance().getInvocationLength());
            }
            if (DubboProviderCollector.getInstance().isAttachmentDetail() && (apmAttachments = String.valueOf(invocation.getAttachments())) != null && apmAttachments.length() > 0) {
                apmSpanEvent.addTag(DubboTags.attachments.name(), apmAttachments, DubboProviderCollector.getInstance().getAttachmentLength());
            }
        }
        return apmSpanEvent;
    }

    private SpanEvent processConsumer(String className, String methodName, Invocation invocation, String serviceUniqueName, String method, String apmServiceType, String source) {
        String userFlag;
        String apmVTraceId;
        DubboConsumerCollector.onStart(serviceUniqueName, method);
        SpanEvent apmSpanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)apmServiceType);
        invocation.getAttachments().put(Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
        invocation.getAttachments().put(Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
        invocation.getAttachments().put(Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
        if (apmSpanEvent != null) {
            apmSpanEvent.addTag("url", source);
            invocation.getAttachments().put(Headers.TRACE_ID.getValue(), apmSpanEvent.getTraceId());
            invocation.getAttachments().put(Headers.SPAN_ID.getValue(), apmSpanEvent.generateNextSpanId());
        }
        if ((apmVTraceId = TraceCollector.getVirtualTraceId()) != null) {
            invocation.getAttachments().put(Headers.GTRACE_ID.getValue(), apmVTraceId);
        }
        if ((userFlag = TraceCollector.getUserFlag()) != null) {
            invocation.getAttachments().put(Headers.USER_FLAG.getValue(), userFlag);
        }
        return apmSpanEvent;
    }

    private void doError(FutureStatsAccessor futureStatsAccessor, Invoker invoker, Invocation invocation, Throwable throwable) {
        SpanEvent spanEvent = futureStatsAccessor.getSpanEvent();
        spanEvent.setHasError(Boolean.TRUE.booleanValue());
        spanEvent.setCode(500);
        String apmRemoteEnvId = "consumer".equals(invoker.getUrl().getParameter("side")) ? invoker.getUrl().getParameter(Headers.ENV_ID.getValue()) : invocation.getAttachment(Headers.ENV_ID.getValue());
        String apmTraceId = spanEvent.getTraceId();
        if ("consumer".equals(invoker.getUrl().getParameter("side"))) {
            DubboConsumerCollector.onError(throwable, futureStatsAccessor.getStartTime(), apmTraceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), apmRemoteEnvId);
        } else {
            DubboProviderCollector.onError(throwable, futureStatsAccessor.getStartTime(), apmTraceId, futureStatsAccessor.getServiceName(), futureStatsAccessor.getMethod(), apmRemoteEnvId);
        }
    }
}

