/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.collector;

import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class ProxyHandler
implements InvocationHandler {
    private Object obj;
    private String traceId;
    private String gtraceId;
    private String spanId;
    private List<String> txName;
    private String userFlag;

    public ProxyHandler(Object obj, String traceId, String spanId, String gtraceId, List<String> txName, String userFlag) {
        this.obj = obj;
        this.traceId = traceId;
        this.spanId = spanId;
        this.gtraceId = gtraceId;
        this.txName = txName;
        this.userFlag = userFlag;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        boolean hasParent = false;
        if ("run".equals(methodName)) {
            Object startTraceRequest;
            if (this.hasParent()) {
                hasParent = true;
            } else {
                if (this.traceId != null && this.spanId != null) {
                    startTraceRequest = new StartTraceRequest(this.obj.getClass().getName(), methodName, this.traceId, this.spanId, this.gtraceId);
                    startTraceRequest.setKind("ASYNC_THREAD");
                    startTraceRequest.setSource(methodName + "()");
                    startTraceRequest.setRealSource(methodName + "()");
                    startTraceRequest.setDomainId(String.valueOf(IdentityConfigManager.getDomainId()));
                    TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                } else if (this.gtraceId != null) {
                    TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(this.gtraceId);
                }
                if (this.userFlag != null) {
                    TraceCollector.USER_FLAG_THREAD_LOCAL.set(this.userFlag);
                }
                if (this.txName != null) {
                    TransactionCollector.setTxName(this.txName);
                }
            }
            try {
                startTraceRequest = method.invoke(this.obj, args);
                return startTraceRequest;
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                TraceCollector.onError((Throwable)ex);
                throw ex;
            }
            catch (Exception e) {
                TraceCollector.onError((Throwable)e);
                throw e;
            }
            finally {
                if (!hasParent) {
                    TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(null);
                    TraceCollector.USER_FLAG_THREAD_LOCAL.set(null);
                    TransactionCollector.clear();
                    Thread t = Thread.currentThread();
                    String name = t.getName();
                    TraceCollector.addTag((String)"threadName", (String)name);
                    TraceCollector.onFinally((int)200);
                }
            }
        }
        try {
            return method.invoke(this.obj, args);
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            throw ex;
        }
    }

    private boolean hasParent() {
        SpanEvent parent = TraceCollector.getSpanEvent();
        return parent != null && !"java/lang/Thread".equals(parent.getClassName());
    }
}

