/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.huawei.bsp.encrypt.cbb.impl;

import com.lubanops.huawei.bsp.encrypt.cbb.KeyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FilenameUtils;

public final class KeyManagerUtil {
    public static final int KEYLEN_SEQUENCE_START = 4;
    public static final int KEYLEN_INT = 4;
    public static final int KEYLEN_DIGEST = 32;
    public static final int KEYLEN_KEYMATIRIAL = 512;
    public static final int KEYLEN_KEYLEN_START = 52;
    public static final int KEYLEN_KEYMATIRIAL_START = 128;
    public static final int KEYLEN_PAD_START = 57;
    public static final int KEYLEN_PADLEN = 71;
    public static final int KEYLEN_ALGLEN_START = 8;
    public static final int KEYLEN_TOTAL = 1024;
    public static final int KEY_COUNT = 16;
    private static final byte[] FILE_VERSION = new byte[]{1, 0, 0, 0};
    private static final int MAX_BUFFER_SIZE = 16385;

    private KeyManagerUtil() {
    }

    public static byte[] sha256(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            return new byte[0];
        }
    }

    private static void concat(byte[] out, byte[] ... src) {
        int len = 0;
        for (byte[] item : src) {
            System.arraycopy(item, 0, out, len, item.length);
            len += item.length;
        }
    }

    public static byte[] intToBytes(int val) {
        return ByteBuffer.allocate(4).putInt(val).array();
    }

    public static byte[] booleanToBytes(boolean b) {
        byte[] byArray;
        if (b) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return byArray;
    }

    public static int bytesToInt(byte[] val) {
        return ByteBuffer.wrap(val).getInt();
    }

    public static void writeKeyFile(byte[] content, File file) throws KeyException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(content);
        }
        catch (IOException e) {
            throw new KeyException("write key file failed.");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] readKeyFile(File file) throws KeyException {
        String path = file.getPath();
        String fileNormalize = FilenameUtils.normalize((String)path);
        File keyFile = new File(fileNormalize);
        FileInputStream in = null;
        try {
            in = new FileInputStream(keyFile);
            byte[] buffer = new byte[16385];
            int len = in.read(buffer);
            if (len <= 0) {
                throw new KeyException("key file is not valid.");
            }
            byte[] result = new byte[len];
            System.arraycopy(buffer, 0, result, 0, len);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            throw new KeyException("read key file failed.");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static int checkKeys(byte[] keys) throws KeyException {
        if (keys.length < 1024 || keys.length > 16384) {
            throw new KeyException("invalid key length.");
        }
        if (keys.length == 1024) {
            byte[] content = new byte[992];
            System.arraycopy(keys, 0, content, 0, content.length);
            byte[] digest = KeyManagerUtil.sha256(content);
            for (int i = 0; i < digest.length; ++i) {
                if (keys[content.length + i] == digest[i]) continue;
                throw new KeyException("invalid key digest.");
            }
            return 1;
        }
        byte[] other = new byte[keys.length - 1024];
        System.arraycopy(keys, 1024, other, 0, other.length);
        return 1 + KeyManagerUtil.checkKeys(other);
    }

    public static byte[] getKeyVersionBytes(byte[] key) {
        byte[] version = new byte[4];
        System.arraycopy(key, 4, version, 0, 4);
        return version;
    }

    public static int getKeyVersionInt(byte[] key) {
        byte[] version = KeyManagerUtil.getKeyVersionBytes(key);
        return KeyManagerUtil.bytesToInt(version);
    }
}

