/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.huawei.bsp.encrypt.cbb.impl;

import com.lubanops.huawei.bsp.encrypt.cbb.CipherException;
import com.lubanops.huawei.bsp.encrypt.cbb.CipherManager;
import com.lubanops.huawei.bsp.encrypt.cbb.CipherUtil;
import com.lubanops.huawei.bsp.encrypt.cbb.KeyException;
import com.lubanops.huawei.bsp.encrypt.cbb.KeyManager;
import com.lubanops.huawei.bsp.encrypt.cbb.KeyType;
import com.lubanops.huawei.bsp.encrypt.cbb.impl.AESCipherCBC;
import com.lubanops.huawei.bsp.encrypt.cbb.impl.DefaultEnvUtil;
import com.lubanops.huawei.bsp.encrypt.cbb.impl.KeyManagerUtil;
import com.lubanops.huawei.bsp.encrypt.cbb.impl.PBKDF2WithHmacSHA256;
import java.io.File;
import java.security.Key;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;

public class CipherManager1
extends CipherManager {
    private static final byte[] VERSION = new byte[]{0, 0, 0, 1};
    private static final byte[] HASH_VERSION1 = new byte[]{0, 0, 0, 1};
    private static final byte[] HASH_VERSION2 = new byte[]{0, 0, 0, 2};
    private static final int SALTLEN = 16;
    private static final String KEY_FILE_SUFFIX = ".key";

    @Override
    public boolean matchPasswordByte(byte[] encrypted, char[] text) throws CipherException {
        if (text == null || text.length == 0) {
            throw new CipherException("empty plain input.");
        }
        if (encrypted == null || encrypted.length <= 16 + HASH_VERSION2.length) {
            throw new CipherException("encrypted not valid.");
        }
        try {
            byte[] salt = new byte[16];
            byte[] version = new byte[HASH_VERSION2.length];
            byte[] hash = new byte[encrypted.length - 16 - HASH_VERSION2.length];
            System.arraycopy(encrypted, 0, version, 0, HASH_VERSION2.length);
            System.arraycopy(encrypted, HASH_VERSION2.length, salt, 0, 16);
            System.arraycopy(encrypted, HASH_VERSION2.length + 16, hash, 0, hash.length);
            if (!Arrays.equals(version, HASH_VERSION2)) {
                return false;
            }
            byte[] target = PBKDF2WithHmacSHA256.passwordHash(text, salt);
            return Arrays.equals(hash, target);
        }
        catch (KeyException e) {
            throw new CipherException(e.getMessage());
        }
    }

    @Override
    public char[] encodePasswordChar(char[] text) throws CipherException {
        byte[] encryptedBytes = this.encodePasswordByte(text);
        return CipherUtil.encodeEncryptedText(encryptedBytes);
    }

    @Override
    public boolean matchPasswordChar(char[] encrypted, char[] text) throws CipherException {
        if (text == null || text.length == 0) {
            throw new CipherException("empty plain input.");
        }
        if (encrypted == null || encrypted.length <= 16) {
            throw new CipherException("empty encrypted input.");
        }
        byte[] encryptedBytes = CipherUtil.decodeEncryptedText(encrypted);
        return this.matchPasswordByte(encryptedBytes, text);
    }

    @Override
    public byte[] encrypt(byte[] plain, KeyType type, String keyName) throws CipherException {
        if (type == KeyType.ROOT) {
            return this.encryptByRootKey(plain, keyName);
        }
        if (type == KeyType.SHARE) {
            return this.encryptByShareKey(plain, keyName);
        }
        return this.encryptByAppKey(plain, keyName);
    }

    private byte[] encryptByRootKey(byte[] plain, String keyName) throws CipherException {
        File dir = new File(FilenameUtils.normalize((String)DefaultEnvUtil.getRootKeyHome()));
        File rootFile = new File(dir, keyName + KEY_FILE_SUFFIX);
        return this.encrypt(plain, rootFile);
    }

    private byte[] encryptByShareKey(byte[] plain, String keyName) throws CipherException {
        File dir = new File(FilenameUtils.normalize((String)DefaultEnvUtil.getRootKeyHome()));
        File rootFile = new File(dir, "root.key");
        File shareFile = new File(dir, keyName + KEY_FILE_SUFFIX);
        return this.encrypt(plain, rootFile, shareFile);
    }

    private byte[] encryptByAppKey(byte[] plain, String keyName) throws CipherException {
        File dir = new File(FilenameUtils.normalize((String)DefaultEnvUtil.getRootKeyHome()));
        File rootFile = new File(dir, "root.key");
        File appdir = new File(FilenameUtils.normalize((String)DefaultEnvUtil.getWorkKeyHome()));
        File appFile = new File(appdir, keyName + KEY_FILE_SUFFIX);
        return this.encrypt(plain, rootFile, appFile);
    }

    @Override
    public char[] encrypt(char[] plain, KeyType type, String keyName) throws CipherException {
        if (plain == null || plain.length == 0) {
            throw new CipherException("empty plain. ");
        }
        byte[] plainBytes = CipherUtil.encodeNoPadding(plain);
        byte[] encryptedBytes = this.encrypt(Base64.decodeBase64((byte[])plainBytes), type, keyName);
        return CipherUtil.encodeEncryptedText(encryptedBytes);
    }

    @Override
    public byte[] decrypt(byte[] encrypted, KeyType type, String keyName) throws CipherException {
        if (type == KeyType.ROOT) {
            return this.decryptByRootKey(encrypted, keyName);
        }
        if (type == KeyType.SHARE) {
            return this.decryptByShareKey(encrypted, keyName);
        }
        return this.decryptByAppKey(encrypted, keyName);
    }

    private byte[] decryptByRootKey(byte[] encrypted, String keyName) throws CipherException {
        File dir = new File(FilenameUtils.normalize((String)DefaultEnvUtil.getRootKeyHome()));
        File rootFile = new File(dir, keyName + KEY_FILE_SUFFIX);
        return this.decrypt(encrypted, rootFile);
    }

    private byte[] decryptByShareKey(byte[] plain, String keyName) throws CipherException {
        File dir = new File(FilenameUtils.normalize((String)DefaultEnvUtil.getRootKeyHome()));
        File rootFile = new File(dir, "root.key");
        File shareFile = new File(dir, keyName + KEY_FILE_SUFFIX);
        return this.decrypt(plain, rootFile, shareFile);
    }

    private byte[] decryptByAppKey(byte[] encrypted, String keyName) throws CipherException {
        File dir = new File(FilenameUtils.normalize((String)DefaultEnvUtil.getRootKeyHome()));
        File rootFile = new File(dir, "root.key");
        File appdir = new File(FilenameUtils.normalize((String)DefaultEnvUtil.getWorkKeyHome()));
        File appFile = new File(appdir, keyName + KEY_FILE_SUFFIX);
        return this.decrypt(encrypted, rootFile, appFile);
    }

    @Override
    public char[] decrypt(char[] encrypted, KeyType type, String keyName) throws CipherException {
        if (encrypted == null || encrypted.length == 0) {
            throw new CipherException("empty plain. ");
        }
        byte[] encryptedBytes = CipherUtil.decodeEncryptedText(encrypted);
        byte[] plainBytes = this.decrypt(encryptedBytes, type, keyName);
        return CipherUtil.decodePlainText(Base64.encodeBase64((byte[])plainBytes));
    }

    @Override
    public char[] encrypt(char[] plain, File rootkey) throws CipherException {
        if (plain == null || plain.length == 0) {
            throw new CipherException("empty plain. ");
        }
        byte[] plainBytes = CipherUtil.encodeNoPadding(plain);
        byte[] encryptedBytes = this.encrypt(plainBytes, rootkey);
        return CipherUtil.encodeEncryptedText(encryptedBytes);
    }

    @Override
    public char[] encrypt(char[] plain, File rootkey, File workkey) throws CipherException {
        if (plain == null || plain.length == 0) {
            throw new CipherException("empty plain. ");
        }
        byte[] plainBytes = CipherUtil.encodeNoPadding(plain);
        byte[] encryptedBytes = this.encrypt(plainBytes, rootkey, workkey);
        return CipherUtil.encodeEncryptedText(encryptedBytes);
    }

    @Override
    public byte[] decrypt(byte[] encrypted, File rootkey) throws CipherException {
        if (encrypted == null || encrypted.length == 0) {
            throw new CipherException("empty input.");
        }
        if (rootkey == null || !rootkey.isFile()) {
            throw new CipherException("rootkey not valid.");
        }
        try {
            byte[] keyversion = new byte[4];
            int keyversioni = KeyManagerUtil.bytesToInt(keyversion);
            Key mapkeyvalue = KeyManager.readRootKey(rootkey, keyversioni);
            return this.getAESDecryptBytes(encrypted, keyversion, mapkeyvalue);
        }
        catch (KeyException e) {
            throw new CipherException(e.getMessage());
        }
    }

    private byte[] getAESDecryptBytes(byte[] encrypted, byte[] keyversion, Key mapkeyvalue) throws CipherException {
        byte[] algversion = new byte[4];
        byte[] encryptedtext = new byte[encrypted.length - 8];
        System.arraycopy(encrypted, 0, algversion, 0, 4);
        System.arraycopy(encrypted, 4, keyversion, 0, 4);
        System.arraycopy(encrypted, 8, encryptedtext, 0, encryptedtext.length);
        this.checkVersionMatch(VERSION, algversion);
        return AESCipherCBC.decrypt(encryptedtext, mapkeyvalue);
    }

    @Override
    public byte[] decrypt(byte[] encrypted, File rootkey, File workkey) throws CipherException {
        if (encrypted == null || encrypted.length == 0) {
            throw new CipherException("empty input.");
        }
        if (rootkey == null || !rootkey.isFile()) {
            throw new CipherException("rootkey not valid.");
        }
        if (workkey == null || !workkey.isFile()) {
            throw new CipherException("workkey not valid.");
        }
        try {
            byte[] keyversion = new byte[4];
            int keyversioni = KeyManagerUtil.bytesToInt(keyversion);
            Key mapkey = KeyManager.readWorkKey(rootkey, workkey, keyversioni);
            return this.getAESDecryptBytes(encrypted, keyversion, mapkey);
        }
        catch (KeyException e) {
            throw new CipherException(e.getMessage());
        }
    }

    @Override
    public char[] decrypt(char[] encrypted, File rootkey) throws CipherException {
        if (encrypted == null || encrypted.length == 0) {
            throw new CipherException("empty plain. ");
        }
        byte[] encryptedBytes = CipherUtil.decodeEncryptedText(encrypted);
        byte[] plainBytes = this.decrypt(encryptedBytes, rootkey);
        return CipherUtil.decodePlainText(plainBytes);
    }

    @Override
    public char[] decrypt(char[] encrypted, File rootkey, File workey) throws CipherException {
        if (encrypted == null || encrypted.length == 0) {
            throw new CipherException("empty plain. ");
        }
        byte[] encryptedBytes = CipherUtil.decodeEncryptedText(encrypted);
        byte[] plainBytes = this.decrypt(encryptedBytes, rootkey, workey);
        return CipherUtil.decodePlainText(plainBytes);
    }

    private void checkVersionMatch(byte[] v1, byte[] v2) throws CipherException {
        if (v1.length != v2.length) {
            throw new CipherException("version not match.");
        }
        for (int i = 0; i < v1.length; ++i) {
            if (v1[i] == v2[i]) continue;
            throw new CipherException("version not match.");
        }
    }

    @Override
    public byte[] encodePasswordByte(char[] text) throws CipherException {
        return null;
    }

    @Override
    public byte[] encrypt(byte[] plain, File rootkey) throws CipherException {
        return null;
    }

    @Override
    public byte[] encrypt(byte[] plain, File rootkey, File workkey) throws CipherException {
        return null;
    }
}

