/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.transformer;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.InterceptorManager;
import com.lubanops.apm.bootstrap.Listener;
import com.lubanops.apm.bootstrap.TransformerMethod;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.core.transformer.CallBack;
import com.lubanops.apm.core.transformer.NoneNamedTransformer;
import com.lubanops.apm.core.transformer.TransformerManager;
import com.lubanops.apm.core.utils.ClassPoolUtils;
import com.lubanops.apm.core.utils.TransformerUtils;
import com.lubanops.apm.integration.exception.JavaagentRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;

public class NamedTransformer {
    private static final Logger LOG = LogFactory.getLogger();
    String interceptorManagerClassName = InterceptorManager.class.getName();
    String interceptorClassName = Interceptor.class.getName();
    private URLClassLoader pluginClassLoader;
    private static Method ADD_URL;

    public NamedTransformer(URLClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, Listener listener) throws IOException, CannotCompileException {
        if (listener != null) {
            List fileds;
            ByteArrayInputStream ins;
            List transformerMethods = listener.getTransformerMethod();
            ClassPool pool = ClassPoolUtils.getClassPool(loader);
            CtClass cc = pool.makeClass((InputStream)(ins = new ByteArrayInputStream(classfileBuffer)));
            if (cc.isInterface()) {
                return classfileBuffer;
            }
            if (transformerMethods != null) {
                for (TransformerMethod transformerMethod : transformerMethods) {
                    try {
                        this.interceptorMethod(loader, className, listener, pool, cc, transformerMethod);
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Interceptor failed for " + className, (Throwable)e);
                    }
                }
            }
            if (listener.hasAttribute()) {
                try {
                    CtClass access = pool.get("com.lubanops.apm.bootstrap.TransformAccess");
                    cc.addInterface(access);
                    CtField param = new CtField(pool.get("java.lang.Object"), "lopsAttribute", cc);
                    param.setModifiers(2);
                    cc.addField(param);
                    cc.addMethod(CtNewMethod.setter((String)"setLopsAttribute", (CtField)param));
                    cc.addMethod(CtNewMethod.getter((String)"getLopsAttribute", (CtField)param));
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Interceptor failed for " + className, (Throwable)e);
                }
            }
            if ((fileds = listener.getFields()) != null && fileds.size() > 0) {
                try {
                    CtClass access = pool.get("com.lubanops.apm.bootstrap.AttributeAccess");
                    if (!cc.subtypeOf(access)) {
                        this.addLopsFields(cc, fileds, access);
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Interceptor failed for " + className, (Throwable)e);
                }
            }
            byte[] bb = cc.toBytecode();
            cc.defrost();
            return bb;
        }
        return classfileBuffer;
    }

    private void addLopsFields(CtClass cc, List<String> fileds, CtClass access) throws CannotCompileException {
        cc.addInterface(access);
        StringBuilder methodCode = new StringBuilder();
        methodCode.append("public Object[] getLopsFileds() {");
        methodCode.append("Object[] result = new Object[" + fileds.size() + "];");
        for (int i = 0; i < fileds.size(); ++i) {
            try {
                cc.getField(fileds.get(i));
                methodCode.append("result[" + i + "]=($w)$0." + fileds.get(i) + ";");
                continue;
            }
            catch (NotFoundException e) {
                methodCode.append("result[" + i + "]=null;");
            }
        }
        methodCode.append("return result;");
        methodCode.append("}");
        CtMethod getMethod = CtMethod.make((String)methodCode.toString(), (CtClass)cc);
        cc.addMethod(getMethod);
    }

    private void interceptorMethod(ClassLoader loader, final String className, Listener listener, final ClassPool pool, CtClass cc, final TransformerMethod transformerMethod) throws IOException, NotFoundException, CannotCompileException {
        final String interceptorName = transformerMethod.getInterceptor();
        final String interceptorKey = this.getInterceptor(loader, interceptorName, listener.getClass().getName());
        if (interceptorKey != null) {
            List<CtBehavior> methods = this.getMethods(transformerMethod, pool, cc);
            if (methods == null) {
                boolean interceptorGetAndSet = transformerMethod.isInterceptorGetAndSet();
                NoneNamedTransformer.interceptorMethods(cc, new ArrayList<String>(), interceptorGetAndSet, new CallBack(){

                    @Override
                    public void interceptor(CtMethod ctmethod, String methodname) throws CannotCompileException, NotFoundException {
                        Set excludeMethods = transformerMethod.getExcludeMethods();
                        if (excludeMethods != null && excludeMethods.contains(methodname.toLowerCase())) {
                            return;
                        }
                        NamedTransformer.this.interceptorMethod((CtBehavior)ctmethod, interceptorKey, interceptorName, className, pool);
                    }
                });
            } else {
                for (CtBehavior m : methods) {
                    this.interceptorMethod(m, interceptorKey, interceptorName, className, pool);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInterceptor(ClassLoader loader, String interceptorName, String listenerClassName) throws IOException {
        try (ZipFile pluginJar = null;){
            Class<?> listenerClass = null;
            try {
                if (loader == null) {
                    listenerClass = Class.forName(listenerClassName);
                } else {
                    listenerClass = loader.loadClass(listenerClassName);
                    if (!listenerClass.getClassLoader().equals(loader)) {
                        throw new ClassNotFoundException();
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (loader == null) {
                    pluginJar = new JarFile(FileUtils.getInterceptorFile((ClassLoader)this.pluginClassLoader, (String)listenerClassName));
                    TransformerManager.getInstrumentation().appendToBootstrapClassLoaderSearch((JarFile)pluginJar);
                    listenerClass = Class.forName(listenerClassName);
                }
                if (loader instanceof URLClassLoader) {
                    ADD_URL.invoke((Object)loader, FileUtils.getInterceptorFile((ClassLoader)this.pluginClassLoader, (String)listenerClassName).toURI().toURL());
                    listenerClass = loader.loadClass(listenerClassName);
                }
                if ("jdk.internal.loader.ClassLoaders$AppClassLoader".equals(loader.getClass().getName())) {
                    pluginJar = new JarFile(FileUtils.getInterceptorFile((ClassLoader)this.pluginClassLoader, (String)listenerClassName));
                    TransformerManager.getInstrumentation().appendToSystemClassLoaderSearch((JarFile)pluginJar);
                    listenerClass = loader.loadClass(listenerClassName);
                }
                File pluginFile = FileUtils.getInterceptorFile((ClassLoader)this.pluginClassLoader, (String)listenerClassName);
                pluginJar = new JarFile(pluginFile);
                Enumeration<JarEntry> entry = ((JarFile)pluginJar).entries();
                while (entry.hasMoreElements()) {
                    if (!TransformerUtils.loadFromFile(loader, (JarFile)pluginJar, entry)) continue;
                }
                listenerClass = loader.loadClass(listenerClassName);
            }
            String string = TransformerUtils.interceptorName(listenerClass, loader, interceptorName);
            return string;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<CtBehavior> getMethods(TransformerMethod transformerMethod, ClassPool pool, CtClass cc) throws NotFoundException {
        List params = transformerMethod.getParams();
        String methodName = transformerMethod.getMethod();
        if (methodName == null) {
            return null;
        }
        ArrayList<CtBehavior> methods = new ArrayList<CtBehavior>();
        if (params == null) {
            if (transformerMethod.isConstructor()) {
                CtConstructor[] ctConstructors;
                for (CtConstructor ctConstructor : ctConstructors = cc.getDeclaredConstructors()) {
                    methods.add((CtBehavior)ctConstructor);
                }
                return methods;
            } else {
                try {
                    CtMethod[] ctmethods;
                    for (CtMethod ctmethod : ctmethods = cc.getDeclaredMethods(methodName)) {
                        methods.add((CtBehavior)ctmethod);
                    }
                    return methods;
                }
                catch (NotFoundException e) {
                    LOG.log(Level.WARNING, cc.getName() + " " + methodName + " NotFoundException ");
                    return methods;
                }
            }
        } else {
            try {
                void var8_19;
                void var8_15;
                CtClass[] paramsClass = new CtClass[params.size()];
                boolean bl = false;
                while (var8_15 < params.size()) {
                    paramsClass[var8_15] = pool.get((String)params.get((int)var8_15));
                    ++var8_15;
                }
                Object var8_16 = null;
                if (transformerMethod.isConstructor()) {
                    CtConstructor ctConstructor = cc.getDeclaredConstructor(paramsClass);
                } else {
                    CtMethod ctMethod = cc.getDeclaredMethod(methodName, paramsClass);
                }
                if (var8_19 == null) return methods;
                methods.add((CtBehavior)var8_19);
                return methods;
            }
            catch (NotFoundException e) {
                LOG.log(Level.WARNING, cc.getName() + " " + methodName + " " + params + " NotFoundException ");
            }
        }
        return methods;
    }

    private void interceptorMethod(CtBehavior m, String interceptorKey, String interceptorName, String className, ClassPool pool) throws NotFoundException, CannotCompileException {
        String methodName = m.getName();
        String startThisStr = "$0";
        if ((8 & m.getMethodInfo().getAccessFlags()) != 0 || m.getMethodInfo().isConstructor()) {
            startThisStr = "null";
        }
        String afterThisStr = "$0";
        if ((8 & m.getMethodInfo().getAccessFlags()) != 0) {
            afterThisStr = "null";
        }
        StringBuilder beforeCode = new StringBuilder();
        beforeCode.append("{");
        beforeCode.append("try{");
        this.buildBase(interceptorKey, interceptorName, beforeCode);
        this.buildLops(m, className, methodName, startThisStr, beforeCode);
        beforeCode.append("}catch(Throwable e){com.lubanops.apm.bootstrap.log.LogFactory.log(e);}");
        beforeCode.append("}");
        m.insertBefore(beforeCode.toString());
        StringBuilder catchCode = new StringBuilder();
        catchCode.append("{");
        catchCode.append("try{");
        this.buildBase(interceptorKey, interceptorName, catchCode);
        catchCode.append("lopsInterceptor.onError(" + startThisStr + ",$args,$e,\"").append(className).append("\",\"").append(methodName).append("\");");
        catchCode.append("}catch(Throwable e){}");
        catchCode.append("throw $e;");
        catchCode.append("}");
        CtClass ec = pool.get("java.lang.Throwable");
        m.addCatch(catchCode.toString(), ec, "$e");
        StringBuilder afterCode = new StringBuilder();
        afterCode.append("{");
        afterCode.append("try{");
        this.buildBase(interceptorKey, interceptorName, afterCode);
        afterCode.append("lopsInterceptor.onFinally(" + afterThisStr + ",$args,($w)$_,\"").append(className).append("\",\"").append(methodName).append("\");");
        afterCode.append("}catch(Throwable e){com.lubanops.apm.bootstrap.log.LogFactory.log(e);return $_;}");
        afterCode.append("}");
        m.insertAfter(afterCode.toString(), true);
    }

    private void buildLops(CtBehavior m, String className, String methodName, String startThisStr, StringBuilder beforeCode) throws NotFoundException {
        beforeCode.append("Object[] lops_args=lopsInterceptor.onStart(" + startThisStr + ",$args,\"").append(className).append("\",\"").append(methodName).append("\");");
        CtClass[] parameterTypes = m.getParameterTypes();
        if (parameterTypes != null && parameterTypes.length > 0) {
            beforeCode.append("if(lops_args!=null && lops_args.length==" + parameterTypes.length + "){");
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i] instanceof CtPrimitiveType) continue;
                beforeCode.append("$" + (i + 1) + "=(" + parameterTypes[i].getName() + ")lops_args[" + i + "];");
            }
            beforeCode.append("}");
        }
    }

    private void buildBase(String interceptorKey, String interceptorName, StringBuilder beforeCode) {
        beforeCode.append(this.interceptorClassName).append(" lopsInterceptor = ").append(this.interceptorManagerClassName).append(".getInterceptor(\"").append(interceptorKey).append("\");");
        beforeCode.append("if(lopsInterceptor==null){");
        beforeCode.append("lopsInterceptor = new ").append(interceptorName).append("();");
        beforeCode.append(this.interceptorManagerClassName).append(".setInterceptor(\"").append(interceptorKey).append("\",lopsInterceptor);");
        beforeCode.append("}");
    }

    static {
        try {
            TransformerManager.initModule();
            ADD_URL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            ADD_URL.setAccessible(true);
        }
        catch (Exception e) {
            throw new JavaagentRuntimeException("Cannot access URLClassLoader.addURL(URL)");
        }
    }
}

