/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.transfer;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.core.common.ConnectionException;
import com.lubanops.apm.core.transfer.AbstractInvokerService;
import com.lubanops.apm.core.utils.ListUtil;
import com.lubanops.apm.integration.access.Address;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.enums.AddressScope;
import com.lubanops.apm.integration.enums.Protocol;
import com.lubanops.apm.integration.transport.websocket.LubanWebSocketClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TransferInvokerService
extends AbstractInvokerService {
    private static final Logger LOG = LogFactory.getLogger();
    private List<Address> innerAddressList = new ArrayList<Address>();
    private List<Address> outerAddressList = new ArrayList<Address>();
    private volatile boolean needReconnect = false;
    private static volatile TransferInvokerService instance;

    public static synchronized TransferInvokerService getInstance() {
        if (instance == null) {
            instance = new TransferInvokerService();
        }
        return instance;
    }

    @Override
    public void setAccessAddressList(List<Address> accessAddressList, boolean isNeedConnect) {
        String configAddress = AgentConfigManager.getAccessAddress();
        if (!StringUtils.isBlank((String)configAddress)) {
            accessAddressList = this.getAddressListFromConfig(configAddress, accessAddressList);
        }
        ArrayList<Address> tmpInnerAddressList = new ArrayList<Address>();
        ArrayList<Address> tmpOuterAddressList = new ArrayList<Address>();
        for (Address address : accessAddressList) {
            if (AddressScope.inner.equals((Object)address.getScope())) {
                tmpInnerAddressList.add(address);
                continue;
            }
            if (!AddressScope.outer.equals((Object)address.getScope())) continue;
            tmpOuterAddressList.add(address);
        }
        if (!ListUtil.isEqualList(this.innerAddressList, tmpInnerAddressList)) {
            this.innerAddressList = tmpInnerAddressList;
            isNeedConnect = true;
        }
        if (!ListUtil.isEqualList(this.outerAddressList, tmpOuterAddressList)) {
            this.outerAddressList = tmpOuterAddressList;
            isNeedConnect = true;
        }
        this.needReconnect = isNeedConnect;
    }

    private List<Address> getAddressListFromConfig(String configAddress, List<Address> accessAddressList) {
        ArrayList<Address> result = new ArrayList<Address>();
        try {
            String[] addressArgs;
            for (String addressArg : addressArgs = configAddress.split(",")) {
                Address address = new Address();
                String[] addr = addressArg.split(":");
                address.setHost(addr[0]);
                int port = Integer.valueOf(addr[1]);
                address.setPort(port);
                address.setSport(port);
                address.setProtocol(Protocol.WS);
                address.setScope(AddressScope.inner);
                result.add(address);
            }
            return result;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "apm.config accessAddress format error", (Throwable)e);
            return accessAddressList;
        }
    }

    @Override
    protected LubanWebSocketClient createConnectConfig() throws ConnectionException {
        LubanWebSocketClient connectConfig;
        if (this.innerAddressList == null && this.outerAddressList == null) {
            throw new ConnectionException("access address is null");
        }
        IOException ex = null;
        try {
            if (this.innerAddressList != null && this.innerAddressList.size() > 0) {
                connectConfig = this.connectTransfer(ex, this.innerAddressList);
                if (connectConfig != null) {
                    return connectConfig;
                }
                LOG.log(Level.SEVERE, "[TRANSFER INVOKER]failed to connect to monitor innerAddressList:" + this.innerAddressList);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "failed to connect to monitor innerAddressList:" + this.innerAddressList + ",exception:" + e.getClass().getName(), (Throwable)e);
            ex = e;
        }
        try {
            if (this.outerAddressList != null && this.outerAddressList.size() > 0) {
                connectConfig = this.connectTransfer(ex, this.outerAddressList);
                if (connectConfig != null) {
                    return connectConfig;
                }
                LOG.log(Level.SEVERE, "[TRANSFER INVOKER]failed to connect to monitor outerAddressList:" + this.outerAddressList);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "failed to connect to monitor outerAddressList:" + this.outerAddressList + ",exception:" + e.getClass().getName(), (Throwable)e);
            ex = e;
        }
        throw new ConnectionException("failed to connect to monitor list", ex);
    }

    private LubanWebSocketClient connectTransfer(IOException ex, List<Address> addressList) throws IOException {
        if (AgentConfigManager.getProxyList().length > 0) {
            List<String> proxyIpList = Arrays.asList(AgentConfigManager.getProxyList());
            Collections.shuffle(proxyIpList);
            Iterator<String> iterator = proxyIpList.iterator();
            if (iterator.hasNext()) {
                String proxy = iterator.next();
                LubanWebSocketClient client = this.connectProxy(addressList, ConfigManager.isSecureChannel(), proxy);
                this.needReconnect = false;
                return client;
            }
        } else {
            LubanWebSocketClient config = this.connect(addressList, ConfigManager.isSecureChannel());
            this.needReconnect = false;
            return config;
        }
        return null;
    }

    @Override
    public void sendDataReport(MessageWrapper message) throws ConnectionException, IOException {
        super.sendRequest(message);
    }

    @Override
    protected boolean needReconnect() {
        return this.needReconnect;
    }

    @Override
    public void setNeedConnect(boolean needConnect) {
        this.needReconnect = needConnect;
    }
}

