/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.monitor;

import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.collector.MonitorItem;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.core.api.IntervalTaskManager;
import com.lubanops.apm.core.executor.manager.DefaultExecuteRepository;
import com.lubanops.apm.core.monitor.HarvestTask;
import com.lubanops.apm.integration.utils.APMThreadFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class HarvestTaskManager
implements IntervalTaskManager<HarvestTask> {
    private static final Logger LOG = LogFactory.getLogger();
    private static volatile HarvestTaskManager instance;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new APMThreadFactory("HarvestTaskThread"));
    private final Map<Integer, HarvestTask> runningTasks = new ConcurrentHashMap<Integer, HarvestTask>();
    private AtomicBoolean onstartReport = new AtomicBoolean(false);

    public static synchronized HarvestTaskManager getInstance() {
        if (instance == null) {
            instance = new HarvestTaskManager();
        }
        return instance;
    }

    @Override
    public void register(HarvestTask task, int interval) {
        this.runningTasks.put(interval, task);
    }

    @Override
    public HarvestTask unRegister(int interval) {
        return this.runningTasks.remove(interval);
    }

    @Override
    public HarvestTask getTask(int interval) {
        return this.runningTasks.get(interval);
    }

    @Override
    public Map<Integer, HarvestTask> getAllTask() {
        return this.runningTasks;
    }

    @Override
    public void stopTask(int interval) {
    }

    @Override
    public void stopAllTasks() {
        try {
            Set<Map.Entry<Integer, HarvestTask>> ss = this.runningTasks.entrySet();
            for (Map.Entry<Integer, HarvestTask> entry : ss) {
                HarvestTask task = entry.getValue();
                ScheduledFuture<?> s = task.getScheduledFuture();
                if (s == null) continue;
                s.cancel(false);
            }
            this.scheduler.shutdown();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "failed to shut down", (Throwable)e);
        }
    }

    public void setMonitorConfigList(List<MonitorItem> monitorConfigList) {
        Set<Integer> keySet = this.runningTasks.keySet();
        HashSet<Integer> oldKeySet = new HashSet<Integer>();
        oldKeySet.addAll(keySet);
        HashMap<Integer, List<MonitorItem>> toAdd = new HashMap<Integer, List<MonitorItem>>();
        HashMap<Integer, List<MonitorItem>> toMaintain = new HashMap<Integer, List<MonitorItem>>();
        HashMap<Integer, List<MonitorItem>> toDelete = new HashMap<Integer, List<MonitorItem>>();
        this.distinguishTasks(monitorConfigList, oldKeySet, toAdd, toMaintain, toDelete);
        Map allCollectors = CollectorManager.newCopyOfCollectors();
        this.newTasks(toAdd, allCollectors);
        this.maintainTasks(toMaintain, allCollectors);
        for (Collector c : allCollectors.values()) {
            c.setEnable(false);
        }
        this.deleteTasks(toDelete);
        if (this.onstartReport.compareAndSet(false, true)) {
            this.collectOnstart();
        }
    }

    private void distinguishTasks(List<MonitorItem> monitorConfigList, Set<Integer> oldKeySet, Map<Integer, List<MonitorItem>> toAdd, Map<Integer, List<MonitorItem>> toMaintain, Map<Integer, List<MonitorItem>> toDelete) {
        HashMap<Integer, LinkedList<MonitorItem>> timeIntervalMap = new HashMap<Integer, LinkedList<MonitorItem>>();
        for (MonitorItem monitorItemApp : monitorConfigList) {
            if (monitorItemApp.getStatus() != 0) continue;
            LinkedList<MonitorItem> taskList = (LinkedList<MonitorItem>)timeIntervalMap.get(monitorItemApp.getInterval());
            if (taskList == null) {
                taskList = new LinkedList<MonitorItem>();
                timeIntervalMap.put(monitorItemApp.getInterval(), taskList);
            }
            taskList.add(monitorItemApp);
        }
        Set currentTaskSet = timeIntervalMap.entrySet();
        for (Map.Entry entry : currentTaskSet) {
            Integer interval = (Integer)entry.getKey();
            List vv = (List)entry.getValue();
            if (oldKeySet.contains(interval)) {
                toMaintain.put(interval, vv);
            } else {
                toAdd.put(interval, vv);
            }
            oldKeySet.remove(interval);
        }
        for (Integer interval : oldKeySet) {
            List ll = Collections.emptyList();
            toDelete.put(interval, ll);
        }
    }

    private void newTasks(Map<Integer, List<MonitorItem>> toAdd, Map<String, Collector> allCollectors) {
        Set<Map.Entry<Integer, List<MonitorItem>>> toAddset = toAdd.entrySet();
        for (Map.Entry<Integer, List<MonitorItem>> ee : toAddset) {
            Integer interval = ee.getKey();
            List<MonitorItem> cList = ee.getValue();
            HarvestTask newTask = new HarvestTask();
            newTask.setMonitorConfigList(cList);
            ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(newTask, interval.intValue(), interval.intValue(), TimeUnit.SECONDS);
            newTask.setScheduledFuture(future);
            this.runningTasks.put(interval, newTask);
            for (MonitorItem c : cList) {
                allCollectors.remove(c.getCollectorName());
            }
        }
    }

    private void maintainTasks(Map<Integer, List<MonitorItem>> toMaintain, Map<String, Collector> allCollectors) {
        Set<Map.Entry<Integer, List<MonitorItem>>> toMaintainSet = toMaintain.entrySet();
        for (Map.Entry<Integer, List<MonitorItem>> ee : toMaintainSet) {
            Integer interval = ee.getKey();
            List<MonitorItem> cList = ee.getValue();
            HarvestTask old = this.getTask(interval);
            if (old != null) {
                old.setMonitorConfigList(cList);
            }
            for (MonitorItem c : cList) {
                allCollectors.remove(c.getCollectorName());
            }
        }
    }

    private void deleteTasks(Map<Integer, List<MonitorItem>> toDelete) {
        Set<Map.Entry<Integer, List<MonitorItem>>> toDeleteSet = toDelete.entrySet();
        for (Map.Entry<Integer, List<MonitorItem>> ee : toDeleteSet) {
            ScheduledFuture<?> future;
            Integer interval = ee.getKey();
            HarvestTask old = this.unRegister(interval);
            if (old == null || (future = old.getScheduledFuture()) == null) continue;
            future.cancel(false);
        }
    }

    private void collectOnstart() {
        ArrayList<MonitorItem> collectorOnstart = new ArrayList<MonitorItem>();
        for (Collector c : CollectorManager.getAllCollectors()) {
            MonitorItem monitorItemApp;
            if (!c.isCollectOnStart() || (monitorItemApp = (MonitorItem)CollectorManager.getMonitorItemMap().get(c.getCollectorName())) == null) continue;
            collectorOnstart.add(monitorItemApp);
        }
        if (!collectorOnstart.isEmpty()) {
            try {
                ExecutorService executorService = DefaultExecuteRepository.getInstance().getSharedExecutor();
                HarvestTask onstartTask = new HarvestTask();
                onstartTask.setMonitorConfigList(collectorOnstart);
                executorService.submit(onstartTask);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "\u6570\u636e\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

