/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.master;

import com.lubanops.apm.bootstrap.agent.AgentInfo;
import com.lubanops.apm.bootstrap.api.TagListener;
import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.LogPathUtils;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.core.api.AgentService;
import com.lubanops.apm.core.common.NamedThreadFactory;
import com.lubanops.apm.core.executor.ExecuteRepository;
import com.lubanops.apm.core.executor.manager.DefaultExecuteRepository;
import com.lubanops.apm.core.executor.timer.AbstractTimerTask;
import com.lubanops.apm.core.master.ConfigService;
import com.lubanops.apm.core.master.MasterService;
import com.lubanops.apm.core.monitor.HarvestTaskManager;
import com.lubanops.apm.core.transfer.TransferInvokerService;
import com.lubanops.apm.core.transfer.dto.HeartBeatRequest;
import com.lubanops.apm.core.transfer.dto.HeartBeatResult;
import com.lubanops.apm.core.transfer.dto.RegisterRequest;
import com.lubanops.apm.core.transfer.dto.RegisterResult;
import com.lubanops.apm.core.transformer.Transformer;
import com.lubanops.apm.core.utils.NetworkUtil;
import com.lubanops.apm.core.utils.ParamsUtils;
import com.lubanops.apm.integration.access.Address;
import com.lubanops.apm.integration.utils.JSON;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class AbstractMasterService
implements MasterService,
ConfigService,
AgentService {
    public static final String APP_TYPE_DEFAULT = "JAVA";
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 60;
    private static final Logger LOGGER = LogFactory.getLogger();
    private static final String SN_FILE = "sn.txt";
    private static final String CONFIG_FILE = "config.txt";
    private final Object heartbeatMonitor = new Object();
    TransferInvokerService invokerService = TransferInvokerService.getInstance();
    HarvestTaskManager harvestTaskManager = HarvestTaskManager.getInstance();
    TagListener tagListener;
    ExecuteRepository executeRepository = DefaultExecuteRepository.getInstance();
    private volatile boolean registrySucess = Boolean.FALSE;
    private String registerUrl;
    private RegisterRequest registered;
    private RegisterResult registerResult;
    private HeartBeatResult lastHeartBeatResult;
    private File snFile;
    private File configFile;
    private HeartBeatTimeTask heartBeatTimeTask;
    private volatile boolean closed = false;

    public AbstractMasterService(String registerUrl) {
        if (StringUtils.isBlank((String)registerUrl)) {
            throw new IllegalArgumentException("register instanceKey is blank");
        }
        this.registerUrl = registerUrl;
        String snFilePath = this.getSnFilePath();
        this.snFile = new File(snFilePath);
        if (!(this.snFile.exists() || this.snFile.getParentFile() == null || this.snFile.getParentFile().exists() || this.snFile.getParentFile().mkdirs())) {
            throw new IllegalArgumentException("invalid master cache file " + this.snFile + "," + this.snFile.getParentFile() + ".");
        }
        LOGGER.info(String.format("[APM MASTER]load local snFile[%s] success.", snFilePath));
        String configPath = this.getConfigFilePath();
        this.configFile = new File(configPath);
        if (!(this.configFile.exists() || this.configFile.getParentFile() == null || this.configFile.getParentFile().exists() || this.configFile.getParentFile().mkdirs())) {
            throw new IllegalArgumentException("invalid master cache file " + this.configFile + "," + this.configFile.getParentFile() + ".");
        }
        LOGGER.info(String.format("[APM MASTER]load local configFile[%s] success.", configPath));
        this.heartBeatTimeTask = new HeartBeatTimeTask(60000L);
    }

    @Override
    public void init() throws ApmRuntimeException {
        this.tagListener = new MasterTagListener();
        this.tagListener.tagAdd(null);
        LOGGER.info(String.format("[APM MASTER]start heartbeat time task[%s] success.", this.heartBeatTimeTask));
        LOGGER.info("[APM MASTER]registry tagListener success.");
    }

    @Override
    public void dispose() throws ApmRuntimeException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.registerUrl = null;
        this.registered = null;
        this.registerResult = null;
        this.lastHeartBeatResult = null;
        this.heartBeatTimeTask = null;
    }

    @Override
    public boolean register() {
        RegisterRequest request = this.buildRegistryRequest();
        LOGGER.info("[APM MASTER]register request: " + request);
        this.setRegistered(request);
        RegisterResult result = this.doRegister(request);
        LOGGER.info("[APM MASTER]register result: " + result);
        if (this.checkRegistered(result)) {
            this.checkRegistryResult(result);
            this.registerResult = result;
            this.registerResult.setAgentVersion(AgentInfo.getJavaagentVersion());
            FileUtils.writeFile((String)this.getSnFilePath(), (String)JSON.toJSONString((Object)result));
            this.invokerService.setNeedConnect(true);
            return true;
        }
        return false;
    }

    @Override
    public int heartbeat() {
        HeartBeatRequest request = this.buildHeartbeatRequest();
        LOGGER.log(Level.FINE, "[APM MASTER]heartbeat request: " + request);
        HeartBeatResult result = this.doHeartbeat(request);
        if (result != null && result.getErrorCode() == null && !StringUtils.isBlank((String)result.getMd5())) {
            if (this.lastHeartBeatResult == null || !result.getMd5().equals(this.lastHeartBeatResult.getMd5())) {
                this.checkHeartbeatResult(result);
                this.lastHeartBeatResult = result;
                this.override(this.lastHeartBeatResult);
                FileUtils.writeFile((String)this.getConfigFilePath(), (String)JSON.toJSONString((Object)result));
                LOGGER.log(Level.INFO, "[APM MASTER]heartbeat md5 update:" + result);
            }
            return this.lastHeartBeatResult.getHeartBeatInterval();
        }
        if (result != null && "apm2.01080001".equals(result.getErrorCode())) {
            ConfigManager.setValidated((boolean)false);
            if (this.lastHeartBeatResult != null) {
                this.lastHeartBeatResult.setMd5("0");
            }
            LOGGER.log(Level.INFO, "[APM MASTER]heartbeat to master failed,wait for next time.", (Throwable)new ApmRuntimeException("[APM MASTER]heartbeat result: " + result));
            this.invokerService.dispose();
            return 0;
        }
        LOGGER.log(Level.INFO, "[APM MASTER]heartbeat to master failed,wait for next time.", (Throwable)new ApmRuntimeException("[APM MASTER]heartbeat result: " + result));
        return 0;
    }

    protected abstract RegisterResult doRegister(RegisterRequest var1);

    protected abstract HeartBeatResult doHeartbeat(HeartBeatRequest var1);

    private String getSnFilePath() {
        return LogPathUtils.getLogPath() + SN_FILE;
    }

    private String getConfigFilePath() {
        return LogPathUtils.getLogPath() + CONFIG_FILE;
    }

    private boolean checkRegister(int heartBeatCount) throws Exception {
        if (!this.registrySucess && this.register()) {
            this.renderIdentity();
            this.registrySucess = true;
            Transformer.initListener();
        }
        return this.registrySucess;
    }

    private void renderIdentity() {
        IdentityConfigManager.setAppId((long)this.registerResult.getAppId());
        IdentityConfigManager.setBizId((long)this.registerResult.getBusinessId());
        IdentityConfigManager.setDomainId((int)this.registerResult.getDomainId());
        IdentityConfigManager.setDomainType((String)this.registerResult.getDomainType());
        IdentityConfigManager.setEnvId((long)this.registerResult.getEnvId());
        IdentityConfigManager.setInstanceId((long)this.registerResult.getInstanceId());
        IdentityConfigManager.setAttachment(this.registerResult.getAttachment());
    }

    private HeartBeatRequest buildHeartbeatRequest() {
        HeartBeatRequest request = new HeartBeatRequest();
        request.setEnvId(IdentityConfigManager.getEnvId());
        request.setInstanceId(IdentityConfigManager.getInstanceId());
        request.setAppId(IdentityConfigManager.getAppId());
        request.setBusinessId(IdentityConfigManager.getBizId());
        request.setDomainId(IdentityConfigManager.getDomainId());
        request.setCollectors(CollectorManager.TAGS);
        request.setAttachment(IdentityConfigManager.getAttachment());
        if (this.lastHeartBeatResult != null && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.lastHeartBeatResult.getMd5())) {
            request.setMd5(this.lastHeartBeatResult.getMd5());
        }
        return request;
    }

    private RegisterRequest buildRegistryRequest() {
        RegisterRequest request = new RegisterRequest();
        List<String> ipList = NetworkUtil.getAllNetworkIp();
        String ipListStr = org.apache.commons.lang3.StringUtils.join(ipList, (String)",");
        request.setHostName(NetworkUtil.getHostName());
        request.setIpList(ipListStr);
        request.setMainIp(ipList.get(0));
        request.setInstanceName(IdentityConfigManager.getInstanceName());
        request.setAppType(APP_TYPE_DEFAULT);
        request.setBusinessName(IdentityConfigManager.getBizPath());
        request.setSubBusiness(IdentityConfigManager.getSubBusiness());
        request.setAppName(IdentityConfigManager.getAppName());
        request.setEnvName(IdentityConfigManager.getEnv());
        request.setEnvTag(IdentityConfigManager.getEnvTag());
        request.setAgentVersion(AgentInfo.getJavaagentVersion());
        if (AgentConfigManager.isServerLess()) {
            request.setSource("FUNC");
        } else if (AgentConfigManager.isDrap()) {
            request.setSource("SOFA_STACK");
        } else if (Util.isDocker()) {
            request.setSource("CONTAINER");
        } else {
            request.setSource("VM");
        }
        return request;
    }

    private void override(HeartBeatResult heartbeatResult) {
        IdentityConfigManager.setBizId((long)heartbeatResult.getBusinessId());
        boolean isNeedConnect = ConfigManager.setSystemProperties(heartbeatResult.getSystemProperties());
        ConfigManager.setValidated((boolean)true);
        CollectorManager.setMonitorItemList(heartbeatResult.getMonitorItemList());
        this.harvestTaskManager.setMonitorConfigList(heartbeatResult.getMonitorItemList());
        List<Address> accessAddressList = heartbeatResult.getAccessAddressList();
        if (accessAddressList != null && accessAddressList.size() > 0) {
            this.invokerService.setAccessAddressList(accessAddressList, isNeedConnect);
        }
        TransactionCollector.setTxConfigItemList(heartbeatResult.getTxConfigItemList());
    }

    protected void checkRegistryResult(RegisterResult result) {
        ParamsUtils.checkArgument(result.getAppId());
        ParamsUtils.checkArgument(result.getBusinessId());
        ParamsUtils.checkArgument(result.getEnvId());
        ParamsUtils.checkArgument(result.getDomainId());
    }

    protected void checkHeartbeatResult(HeartBeatResult result) {
        ParamsUtils.checkArgument(result.getBusinessId());
        ParamsUtils.checkArgument(result.getMd5());
        ParamsUtils.checkArgument(result.getHeartBeatInterval());
        ParamsUtils.checkArgument(result.getAccessAddressList());
        ParamsUtils.checkArgument(result.getMonitorItemList());
    }

    public String getRegisterUrl() {
        return this.registerUrl;
    }

    public void setRegisterUrl(String registerUrl) {
        this.registerUrl = registerUrl;
    }

    public RegisterRequest getRegistered() {
        return this.registered;
    }

    public void setRegistered(RegisterRequest registered) {
        this.registered = registered;
    }

    private boolean checkRegistered(RegisterResult result) {
        return result != null && result.getInstanceId() > 0L;
    }

    protected final class HeartBeatTimeTask
    extends AbstractTimerTask {
        private static final String TASK_NAME = "HeartbeatTimeTask";
        private int circuitCount;
        private int retryHeartbeat;
        private volatile boolean heartbeatSuccess;

        public HeartBeatTimeTask(long heartbeatInterval) {
            super(heartbeatInterval);
            this.circuitCount = 0;
            this.retryHeartbeat = 0;
            this.heartbeatSuccess = Boolean.FALSE;
        }

        public HeartBeatTimeTask reset() {
            HeartBeatTimeTask newTask = new HeartBeatTimeTask(this.getTick());
            newTask.setCircuitCount(this.circuitCount);
            newTask.setRetryHeartbeat(this.retryHeartbeat);
            return newTask;
        }

        @Override
        public String getName() {
            return TASK_NAME;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            Object object = AbstractMasterService.this.heartbeatMonitor;
            synchronized (object) {
                try {
                    ++this.circuitCount;
                    if (this.heartbeatSuccess || this.needRetry()) {
                        this.doTry();
                    }
                }
                catch (Throwable e) {
                    if (this.heartbeatSuccess) {
                        this.circuitCount = 0;
                        this.heartbeatSuccess = false;
                        this.retryHeartbeat = 0;
                    }
                    ++this.retryHeartbeat;
                    LOGGER.log(Level.SEVERE, String.format("[APM MASTER]task[%s] has exception.", this), e);
                }
            }
        }

        private void doTry() throws Exception {
            if (AbstractMasterService.this.checkRegister(0)) {
                int nextInterval = AbstractMasterService.this.heartbeat();
                if (nextInterval > 0) {
                    if (!this.heartbeatSuccess) {
                        this.heartbeatSuccess = true;
                        this.circuitCount = 0;
                        this.retryHeartbeat = 0;
                    }
                    this.setTick((long)nextInterval * 1000L);
                } else if (this.heartbeatSuccess) {
                    this.circuitCount = 0;
                    this.heartbeatSuccess = false;
                    this.retryHeartbeat = 0;
                } else {
                    ++this.retryHeartbeat;
                }
            } else {
                if (this.heartbeatSuccess) {
                    this.circuitCount = 0;
                    this.heartbeatSuccess = false;
                    this.retryHeartbeat = 0;
                }
                ++this.retryHeartbeat;
            }
        }

        private boolean needRetry() {
            if (this.retryHeartbeat <= 8) {
                return true;
            }
            int offset = this.circuitCount;
            boolean result = this.retryHeartbeat - 8 > 4 ? offset % 16 == 0 : offset >= 8 + (int)Math.pow(2.0, this.retryHeartbeat - 8);
            return result;
        }

        public int getCircuitCount() {
            return this.circuitCount;
        }

        public void setCircuitCount(int circuitCount) {
            this.circuitCount = circuitCount;
        }

        public void setRetryHeartbeat(int retryHeartbeat) {
            this.retryHeartbeat = retryHeartbeat;
        }

        public boolean isHeartbeatSuccess() {
            return this.heartbeatSuccess;
        }

        public void setHeartbeatSuccess(boolean heartbeatSuccess) {
            this.heartbeatSuccess = heartbeatSuccess;
        }

        public String toString() {
            return JSON.toJSONString((Object)this);
        }
    }

    private class MasterTagListener
    implements TagListener {
        private MasterTagListener() {
        }

        public void tagAdd(String tag) {
            if (AgentConfigManager.isServerLess()) {
                AbstractMasterService.this.register();
                if (AbstractMasterService.this.registerResult != null) {
                    AbstractMasterService.this.renderIdentity();
                }
                AbstractMasterService.this.heartbeat();
            }
            AbstractMasterService.this.executeRepository.getSharedExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractMasterService.this.heartBeatTimeTask.cancel();
                        Thread.sleep(500L);
                        AbstractMasterService.this.heartBeatTimeTask.doTask();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "[APM MASTER]heartbeat immediately failed,waiting for task executing.");
                    }
                    AbstractMasterService.this.heartBeatTimeTask = AbstractMasterService.this.heartBeatTimeTask.reset();
                    Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("APM-heartBeatThread", true)).scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            AbstractMasterService.this.heartBeatTimeTask.doTask();
                        }
                    }, 60L, 60L, TimeUnit.SECONDS);
                }
            });
        }
    }
}

